package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class StartChannelResponse(
    arn: Option[__string] = None,
    cdiInputSpecification: Option[
      zio.aws.medialive.model.CdiInputSpecification
    ] = None,
    channelClass: Option[zio.aws.medialive.model.ChannelClass] = None,
    destinations: Option[Iterable[zio.aws.medialive.model.OutputDestination]] =
      None,
    egressEndpoints: Option[
      Iterable[zio.aws.medialive.model.ChannelEgressEndpoint]
    ] = None,
    encoderSettings: Option[zio.aws.medialive.model.EncoderSettings] = None,
    id: Option[__string] = None,
    inputAttachments: Option[
      Iterable[zio.aws.medialive.model.InputAttachment]
    ] = None,
    inputSpecification: Option[zio.aws.medialive.model.InputSpecification] =
      None,
    logLevel: Option[zio.aws.medialive.model.LogLevel] = None,
    maintenance: Option[zio.aws.medialive.model.MaintenanceStatus] = None,
    name: Option[__string] = None,
    pipelineDetails: Option[Iterable[zio.aws.medialive.model.PipelineDetail]] =
      None,
    pipelinesRunningCount: Option[__integer] = None,
    roleArn: Option[__string] = None,
    state: Option[zio.aws.medialive.model.ChannelState] = None,
    tags: Option[Map[__string, __string]] = None,
    vpc: Option[zio.aws.medialive.model.VpcOutputSettingsDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StartChannelResponse = {
    import StartChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StartChannelResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        cdiInputSpecification.map(value => value.buildAwsValue())
      )(_.cdiInputSpecification)
      .optionallyWith(channelClass.map(value => value.unwrap))(_.channelClass)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        egressEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressEndpoints)
      .optionallyWith(encoderSettings.map(value => value.buildAwsValue()))(
        _.encoderSettings
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        inputAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputAttachments)
      .optionallyWith(inputSpecification.map(value => value.buildAwsValue()))(
        _.inputSpecification
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(maintenance.map(value => value.buildAwsValue()))(
        _.maintenance
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        pipelineDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineDetails)
      .optionallyWith(pipelinesRunningCount.map(value => value: Integer))(
        _.pipelinesRunningCount
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.StartChannelResponse.ReadOnly =
    zio.aws.medialive.model.StartChannelResponse.wrap(buildAwsValue())
}
object StartChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StartChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.StartChannelResponse =
      zio.aws.medialive.model.StartChannelResponse(
        arn.map(value => value),
        cdiInputSpecification.map(value => value.asEditable),
        channelClass.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        egressEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encoderSettings.map(value => value.asEditable),
        id.map(value => value),
        inputAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputSpecification.map(value => value.asEditable),
        logLevel.map(value => value),
        maintenance.map(value => value.asEditable),
        name.map(value => value),
        pipelineDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pipelinesRunningCount.map(value => value),
        roleArn.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        vpc.map(value => value.asEditable)
      )
    def arn: Option[__string]
    def cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly]
    def channelClass: Option[zio.aws.medialive.model.ChannelClass]
    def destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]]
    def egressEndpoints
        : Option[List[zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly]]
    def encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly]
    def id: Option[__string]
    def inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]]
    def inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly]
    def logLevel: Option[zio.aws.medialive.model.LogLevel]
    def maintenance: Option[zio.aws.medialive.model.MaintenanceStatus.ReadOnly]
    def name: Option[__string]
    def pipelineDetails
        : Option[List[zio.aws.medialive.model.PipelineDetail.ReadOnly]]
    def pipelinesRunningCount: Option[__integer]
    def roleArn: Option[__string]
    def state: Option[zio.aws.medialive.model.ChannelState]
    def tags: Option[Map[__string, __string]]
    def vpc
        : Option[zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCdiInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CdiInputSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("cdiInputSpecification", cdiInputSpecification)
    def getChannelClass
        : ZIO[Any, AwsError, zio.aws.medialive.model.ChannelClass] =
      AwsError.unwrapOptionField("channelClass", channelClass)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.OutputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getEgressEndpoints: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("egressEndpoints", egressEndpoints)
    def getEncoderSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.EncoderSettings.ReadOnly] =
      AwsError.unwrapOptionField("encoderSettings", encoderSettings)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getInputAttachments: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("inputAttachments", inputAttachments)
    def getInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("inputSpecification", inputSpecification)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.medialive.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getMaintenance: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MaintenanceStatus.ReadOnly
    ] = AwsError.unwrapOptionField("maintenance", maintenance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPipelineDetails: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.PipelineDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelineDetails", pipelineDetails)
    def getPipelinesRunningCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("pipelinesRunningCount", pipelinesRunningCount)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getState: ZIO[Any, AwsError, zio.aws.medialive.model.ChannelState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpc: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StartChannelResponse
  ) extends zio.aws.medialive.model.StartChannelResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly] = scala
      .Option(impl.cdiInputSpecification())
      .map(value => zio.aws.medialive.model.CdiInputSpecification.wrap(value))
    override val channelClass: Option[zio.aws.medialive.model.ChannelClass] =
      scala
        .Option(impl.channelClass())
        .map(value => zio.aws.medialive.model.ChannelClass.wrap(value))
    override val destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]] =
      scala
        .Option(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.OutputDestination.wrap(item)
          }.toList
        )
    override val egressEndpoints
        : Option[List[zio.aws.medialive.model.ChannelEgressEndpoint.ReadOnly]] =
      scala
        .Option(impl.egressEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.ChannelEgressEndpoint.wrap(item)
          }.toList
        )
    override val encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly] = scala
      .Option(impl.encoderSettings())
      .map(value => zio.aws.medialive.model.EncoderSettings.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]] = scala
      .Option(impl.inputAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputAttachment.wrap(item)
        }.toList
      )
    override val inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly] = scala
      .Option(impl.inputSpecification())
      .map(value => zio.aws.medialive.model.InputSpecification.wrap(value))
    override val logLevel: Option[zio.aws.medialive.model.LogLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.medialive.model.LogLevel.wrap(value))
    override val maintenance
        : Option[zio.aws.medialive.model.MaintenanceStatus.ReadOnly] = scala
      .Option(impl.maintenance())
      .map(value => zio.aws.medialive.model.MaintenanceStatus.wrap(value))
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val pipelineDetails
        : Option[List[zio.aws.medialive.model.PipelineDetail.ReadOnly]] = scala
      .Option(impl.pipelineDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.PipelineDetail.wrap(item)
        }.toList
      )
    override val pipelinesRunningCount: Option[__integer] =
      scala.Option(impl.pipelinesRunningCount()).map(value => value: __integer)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
    override val state: Option[zio.aws.medialive.model.ChannelState] = scala
      .Option(impl.state())
      .map(value => zio.aws.medialive.model.ChannelState.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val vpc: Option[
      zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.vpc())
      .map(value =>
        zio.aws.medialive.model.VpcOutputSettingsDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StartChannelResponse
  ): zio.aws.medialive.model.StartChannelResponse.ReadOnly = new Wrapper(impl)
}
