package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class StartTimecode(timecode: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StartTimecode = {
    import StartTimecode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StartTimecode
      .builder()
      .optionallyWith(timecode.map(value => value: java.lang.String))(
        _.timecode
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.StartTimecode.ReadOnly =
    zio.aws.medialive.model.StartTimecode.wrap(buildAwsValue())
}
object StartTimecode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StartTimecode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.StartTimecode =
      zio.aws.medialive.model.StartTimecode(timecode.map(value => value))
    def timecode: Option[__string]
    def getTimecode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timecode", timecode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StartTimecode
  ) extends zio.aws.medialive.model.StartTimecode.ReadOnly {
    override val timecode: Option[__string] =
      scala.Option(impl.timecode()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StartTimecode
  ): zio.aws.medialive.model.StartTimecode.ReadOnly = new Wrapper(impl)
}
