package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max100,
  __integerMin0Max7,
  __integerMin1,
  __integerMin0
}
import scala.jdk.CollectionConverters._
final case class StaticImageActivateScheduleActionSettings(
    duration: Option[__integerMin0] = None,
    fadeIn: Option[__integerMin0] = None,
    fadeOut: Option[__integerMin0] = None,
    height: Option[__integerMin1] = None,
    image: zio.aws.medialive.model.InputLocation,
    imageX: Option[__integerMin0] = None,
    imageY: Option[__integerMin0] = None,
    layer: Option[__integerMin0Max7] = None,
    opacity: Option[__integerMin0Max100] = None,
    width: Option[__integerMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings = {
    import StaticImageActivateScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings
      .builder()
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(fadeIn.map(value => value: Integer))(_.fadeIn)
      .optionallyWith(fadeOut.map(value => value: Integer))(_.fadeOut)
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .image(image.buildAwsValue())
      .optionallyWith(imageX.map(value => value: Integer))(_.imageX)
      .optionallyWith(imageY.map(value => value: Integer))(_.imageY)
      .optionallyWith(layer.map(value => value: Integer))(_.layer)
      .optionallyWith(opacity.map(value => value: Integer))(_.opacity)
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.StaticImageActivateScheduleActionSettings
      .wrap(buildAwsValue())
}
object StaticImageActivateScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.StaticImageActivateScheduleActionSettings =
      zio.aws.medialive.model.StaticImageActivateScheduleActionSettings(
        duration.map(value => value),
        fadeIn.map(value => value),
        fadeOut.map(value => value),
        height.map(value => value),
        image.asEditable,
        imageX.map(value => value),
        imageY.map(value => value),
        layer.map(value => value),
        opacity.map(value => value),
        width.map(value => value)
      )
    def duration: Option[__integerMin0]
    def fadeIn: Option[__integerMin0]
    def fadeOut: Option[__integerMin0]
    def height: Option[__integerMin1]
    def image: zio.aws.medialive.model.InputLocation.ReadOnly
    def imageX: Option[__integerMin0]
    def imageY: Option[__integerMin0]
    def layer: Option[__integerMin0Max7]
    def opacity: Option[__integerMin0Max100]
    def width: Option[__integerMin1]
    def getDuration: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("duration", duration)
    def getFadeIn: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("fadeIn", fadeIn)
    def getFadeOut: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("fadeOut", fadeOut)
    def getHeight: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("height", height)
    def getImage
        : ZIO[Any, Nothing, zio.aws.medialive.model.InputLocation.ReadOnly] =
      ZIO.succeed(image)
    def getImageX: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("imageX", imageX)
    def getImageY: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("imageY", imageY)
    def getLayer: ZIO[Any, AwsError, __integerMin0Max7] =
      AwsError.unwrapOptionField("layer", layer)
    def getOpacity: ZIO[Any, AwsError, __integerMin0Max100] =
      AwsError.unwrapOptionField("opacity", opacity)
    def getWidth: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("width", width)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings
  ) extends zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly {
    override val duration: Option[__integerMin0] =
      scala.Option(impl.duration()).map(value => value: __integerMin0)
    override val fadeIn: Option[__integerMin0] =
      scala.Option(impl.fadeIn()).map(value => value: __integerMin0)
    override val fadeOut: Option[__integerMin0] =
      scala.Option(impl.fadeOut()).map(value => value: __integerMin0)
    override val height: Option[__integerMin1] =
      scala.Option(impl.height()).map(value => value: __integerMin1)
    override val image: zio.aws.medialive.model.InputLocation.ReadOnly =
      zio.aws.medialive.model.InputLocation.wrap(impl.image())
    override val imageX: Option[__integerMin0] =
      scala.Option(impl.imageX()).map(value => value: __integerMin0)
    override val imageY: Option[__integerMin0] =
      scala.Option(impl.imageY()).map(value => value: __integerMin0)
    override val layer: Option[__integerMin0Max7] =
      scala.Option(impl.layer()).map(value => value: __integerMin0Max7)
    override val opacity: Option[__integerMin0Max100] =
      scala.Option(impl.opacity()).map(value => value: __integerMin0Max100)
    override val width: Option[__integerMin1] =
      scala.Option(impl.width()).map(value => value: __integerMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StaticImageActivateScheduleActionSettings
  ): zio.aws.medialive.model.StaticImageActivateScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
