package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin0Max7, __integerMin0}
import scala.jdk.CollectionConverters._
final case class StaticImageDeactivateScheduleActionSettings(
    fadeOut: Option[__integerMin0] = None,
    layer: Option[__integerMin0Max7] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings = {
    import StaticImageDeactivateScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings
      .builder()
      .optionallyWith(fadeOut.map(value => value: Integer))(_.fadeOut)
      .optionallyWith(layer.map(value => value: Integer))(_.layer)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings
      .wrap(buildAwsValue())
}
object StaticImageDeactivateScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings =
      zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings(
        fadeOut.map(value => value),
        layer.map(value => value)
      )
    def fadeOut: Option[__integerMin0]
    def layer: Option[__integerMin0Max7]
    def getFadeOut: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("fadeOut", fadeOut)
    def getLayer: ZIO[Any, AwsError, __integerMin0Max7] =
      AwsError.unwrapOptionField("layer", layer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings
  ) extends zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly {
    override val fadeOut: Option[__integerMin0] =
      scala.Option(impl.fadeOut()).map(value => value: __integerMin0)
    override val layer: Option[__integerMin0Max7] =
      scala.Option(impl.layer()).map(value => value: __integerMin0Max7)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StaticImageDeactivateScheduleActionSettings
  ): zio.aws.medialive.model.StaticImageDeactivateScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
