package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin32Max32
import scala.jdk.CollectionConverters._
final case class StaticKeySettings(
    keyProviderServer: Option[zio.aws.medialive.model.InputLocation] = None,
    staticKeyValue: __stringMin32Max32
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StaticKeySettings = {
    import StaticKeySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StaticKeySettings
      .builder()
      .optionallyWith(keyProviderServer.map(value => value.buildAwsValue()))(
        _.keyProviderServer
      )
      .staticKeyValue(staticKeyValue: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.StaticKeySettings.ReadOnly =
    zio.aws.medialive.model.StaticKeySettings.wrap(buildAwsValue())
}
object StaticKeySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StaticKeySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.StaticKeySettings =
      zio.aws.medialive.model.StaticKeySettings(
        keyProviderServer.map(value => value.asEditable),
        staticKeyValue
      )
    def keyProviderServer
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def staticKeyValue: __stringMin32Max32
    def getKeyProviderServer
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("keyProviderServer", keyProviderServer)
    def getStaticKeyValue: ZIO[Any, Nothing, __stringMin32Max32] =
      ZIO.succeed(staticKeyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StaticKeySettings
  ) extends zio.aws.medialive.model.StaticKeySettings.ReadOnly {
    override val keyProviderServer
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.keyProviderServer())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val staticKeyValue: __stringMin32Max32 =
      impl.staticKeyValue(): __stringMin32Max32
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StaticKeySettings
  ): zio.aws.medialive.model.StaticKeySettings.ReadOnly = new Wrapper(impl)
}
