package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class StopTimecode(
    lastFrameClippingBehavior: Option[
      zio.aws.medialive.model.LastFrameClippingBehavior
    ] = None,
    timecode: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.StopTimecode = {
    import StopTimecode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.StopTimecode
      .builder()
      .optionallyWith(lastFrameClippingBehavior.map(value => value.unwrap))(
        _.lastFrameClippingBehavior
      )
      .optionallyWith(timecode.map(value => value: java.lang.String))(
        _.timecode
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.StopTimecode.ReadOnly =
    zio.aws.medialive.model.StopTimecode.wrap(buildAwsValue())
}
object StopTimecode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.StopTimecode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.StopTimecode =
      zio.aws.medialive.model.StopTimecode(
        lastFrameClippingBehavior.map(value => value),
        timecode.map(value => value)
      )
    def lastFrameClippingBehavior
        : Option[zio.aws.medialive.model.LastFrameClippingBehavior]
    def timecode: Option[__string]
    def getLastFrameClippingBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.LastFrameClippingBehavior
    ] = AwsError.unwrapOptionField(
      "lastFrameClippingBehavior",
      lastFrameClippingBehavior
    )
    def getTimecode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timecode", timecode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.StopTimecode
  ) extends zio.aws.medialive.model.StopTimecode.ReadOnly {
    override val lastFrameClippingBehavior
        : Option[zio.aws.medialive.model.LastFrameClippingBehavior] = scala
      .Option(impl.lastFrameClippingBehavior())
      .map(value =>
        zio.aws.medialive.model.LastFrameClippingBehavior.wrap(value)
      )
    override val timecode: Option[__string] =
      scala.Option(impl.timecode()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.StopTimecode
  ): zio.aws.medialive.model.StopTimecode.ReadOnly = new Wrapper(impl)
}
