package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TeletextSourceSettings(
    outputRectangle: Option[zio.aws.medialive.model.CaptionRectangle] = None,
    pageNumber: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TeletextSourceSettings = {
    import TeletextSourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TeletextSourceSettings
      .builder()
      .optionallyWith(outputRectangle.map(value => value.buildAwsValue()))(
        _.outputRectangle
      )
      .optionallyWith(pageNumber.map(value => value: java.lang.String))(
        _.pageNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.TeletextSourceSettings.ReadOnly =
    zio.aws.medialive.model.TeletextSourceSettings.wrap(buildAwsValue())
}
object TeletextSourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TeletextSourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TeletextSourceSettings =
      zio.aws.medialive.model.TeletextSourceSettings(
        outputRectangle.map(value => value.asEditable),
        pageNumber.map(value => value)
      )
    def outputRectangle
        : Option[zio.aws.medialive.model.CaptionRectangle.ReadOnly]
    def pageNumber: Option[__string]
    def getOutputRectangle: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CaptionRectangle.ReadOnly
    ] = AwsError.unwrapOptionField("outputRectangle", outputRectangle)
    def getPageNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TeletextSourceSettings
  ) extends zio.aws.medialive.model.TeletextSourceSettings.ReadOnly {
    override val outputRectangle
        : Option[zio.aws.medialive.model.CaptionRectangle.ReadOnly] = scala
      .Option(impl.outputRectangle())
      .map(value => zio.aws.medialive.model.CaptionRectangle.wrap(value))
    override val pageNumber: Option[__string] =
      scala.Option(impl.pageNumber()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TeletextSourceSettings
  ): zio.aws.medialive.model.TeletextSourceSettings.ReadOnly = new Wrapper(impl)
}
