package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TemporalFilterSettings(
    postFilterSharpening: Option[
      zio.aws.medialive.model.TemporalFilterPostFilterSharpening
    ] = None,
    strength: Option[zio.aws.medialive.model.TemporalFilterStrength] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TemporalFilterSettings = {
    import TemporalFilterSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TemporalFilterSettings
      .builder()
      .optionallyWith(postFilterSharpening.map(value => value.unwrap))(
        _.postFilterSharpening
      )
      .optionallyWith(strength.map(value => value.unwrap))(_.strength)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.TemporalFilterSettings.ReadOnly =
    zio.aws.medialive.model.TemporalFilterSettings.wrap(buildAwsValue())
}
object TemporalFilterSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TemporalFilterSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TemporalFilterSettings =
      zio.aws.medialive.model.TemporalFilterSettings(
        postFilterSharpening.map(value => value),
        strength.map(value => value)
      )
    def postFilterSharpening
        : Option[zio.aws.medialive.model.TemporalFilterPostFilterSharpening]
    def strength: Option[zio.aws.medialive.model.TemporalFilterStrength]
    def getPostFilterSharpening: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TemporalFilterPostFilterSharpening
    ] = AwsError.unwrapOptionField("postFilterSharpening", postFilterSharpening)
    def getStrength
        : ZIO[Any, AwsError, zio.aws.medialive.model.TemporalFilterStrength] =
      AwsError.unwrapOptionField("strength", strength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TemporalFilterSettings
  ) extends zio.aws.medialive.model.TemporalFilterSettings.ReadOnly {
    override val postFilterSharpening
        : Option[zio.aws.medialive.model.TemporalFilterPostFilterSharpening] =
      scala
        .Option(impl.postFilterSharpening())
        .map(value =>
          zio.aws.medialive.model.TemporalFilterPostFilterSharpening.wrap(value)
        )
    override val strength
        : Option[zio.aws.medialive.model.TemporalFilterStrength] = scala
      .Option(impl.strength())
      .map(value => zio.aws.medialive.model.TemporalFilterStrength.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TemporalFilterSettings
  ): zio.aws.medialive.model.TemporalFilterSettings.ReadOnly = new Wrapper(impl)
}
