package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1Max1000000
import scala.jdk.CollectionConverters._
final case class TimecodeConfig(
    source: zio.aws.medialive.model.TimecodeConfigSource,
    syncThreshold: Option[__integerMin1Max1000000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TimecodeConfig = {
    import TimecodeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TimecodeConfig
      .builder()
      .source(source.unwrap)
      .optionallyWith(syncThreshold.map(value => value: Integer))(
        _.syncThreshold
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.TimecodeConfig.ReadOnly =
    zio.aws.medialive.model.TimecodeConfig.wrap(buildAwsValue())
}
object TimecodeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TimecodeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TimecodeConfig =
      zio.aws.medialive.model
        .TimecodeConfig(source, syncThreshold.map(value => value))
    def source: zio.aws.medialive.model.TimecodeConfigSource
    def syncThreshold: Option[__integerMin1Max1000000]
    def getSource
        : ZIO[Any, Nothing, zio.aws.medialive.model.TimecodeConfigSource] =
      ZIO.succeed(source)
    def getSyncThreshold: ZIO[Any, AwsError, __integerMin1Max1000000] =
      AwsError.unwrapOptionField("syncThreshold", syncThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TimecodeConfig
  ) extends zio.aws.medialive.model.TimecodeConfig.ReadOnly {
    override val source: zio.aws.medialive.model.TimecodeConfigSource =
      zio.aws.medialive.model.TimecodeConfigSource.wrap(impl.source())
    override val syncThreshold: Option[__integerMin1Max1000000] = scala
      .Option(impl.syncThreshold())
      .map(value => value: __integerMin1Max1000000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TimecodeConfig
  ): zio.aws.medialive.model.TimecodeConfig.ReadOnly = new Wrapper(impl)
}
