package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait TimecodeConfigSource {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.TimecodeConfigSource
}
object TimecodeConfigSource {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.TimecodeConfigSource
  ): zio.aws.medialive.model.TimecodeConfigSource = value match {
    case software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.EMBEDDED =>
      val r = EMBEDDED
      r
    case software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.SYSTEMCLOCK =>
      val r = SYSTEMCLOCK
      r
    case software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.ZEROBASED =>
      val r = ZEROBASED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.TimecodeConfigSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TimecodeConfigSource =
      software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.UNKNOWN_TO_SDK_VERSION
  }
  case object EMBEDDED extends zio.aws.medialive.model.TimecodeConfigSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TimecodeConfigSource =
      software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.EMBEDDED
  }
  case object SYSTEMCLOCK extends zio.aws.medialive.model.TimecodeConfigSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TimecodeConfigSource =
      software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.SYSTEMCLOCK
  }
  case object ZEROBASED extends zio.aws.medialive.model.TimecodeConfigSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TimecodeConfigSource =
      software.amazon.awssdk.services.medialive.model.TimecodeConfigSource.ZEROBASED
  }
}
