package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TransferInputDeviceRequest(
    inputDeviceId: __string,
    targetCustomerId: Option[__string] = None,
    targetRegion: Option[__string] = None,
    transferMessage: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest = {
    import TransferInputDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest
      .builder()
      .inputDeviceId(inputDeviceId: java.lang.String)
      .optionallyWith(targetCustomerId.map(value => value: java.lang.String))(
        _.targetCustomerId
      )
      .optionallyWith(targetRegion.map(value => value: java.lang.String))(
        _.targetRegion
      )
      .optionallyWith(transferMessage.map(value => value: java.lang.String))(
        _.transferMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.TransferInputDeviceRequest.ReadOnly =
    zio.aws.medialive.model.TransferInputDeviceRequest.wrap(buildAwsValue())
}
object TransferInputDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TransferInputDeviceRequest =
      zio.aws.medialive.model.TransferInputDeviceRequest(
        inputDeviceId,
        targetCustomerId.map(value => value),
        targetRegion.map(value => value),
        transferMessage.map(value => value)
      )
    def inputDeviceId: __string
    def targetCustomerId: Option[__string]
    def targetRegion: Option[__string]
    def transferMessage: Option[__string]
    def getInputDeviceId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(inputDeviceId)
    def getTargetCustomerId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("targetCustomerId", targetCustomerId)
    def getTargetRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("targetRegion", targetRegion)
    def getTransferMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transferMessage", transferMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest
  ) extends zio.aws.medialive.model.TransferInputDeviceRequest.ReadOnly {
    override val inputDeviceId: __string = impl.inputDeviceId(): __string
    override val targetCustomerId: Option[__string] =
      scala.Option(impl.targetCustomerId()).map(value => value: __string)
    override val targetRegion: Option[__string] =
      scala.Option(impl.targetRegion()).map(value => value: __string)
    override val transferMessage: Option[__string] =
      scala.Option(impl.transferMessage()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest
  ): zio.aws.medialive.model.TransferInputDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
