package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TransferringInputDeviceSummary(
    id: Option[__string] = None,
    message: Option[__string] = None,
    targetCustomerId: Option[__string] = None,
    transferType: Option[zio.aws.medialive.model.InputDeviceTransferType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary = {
    import TransferringInputDeviceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(targetCustomerId.map(value => value: java.lang.String))(
        _.targetCustomerId
      )
      .optionallyWith(transferType.map(value => value.unwrap))(_.transferType)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly =
    zio.aws.medialive.model.TransferringInputDeviceSummary.wrap(buildAwsValue())
}
object TransferringInputDeviceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TransferringInputDeviceSummary =
      zio.aws.medialive.model.TransferringInputDeviceSummary(
        id.map(value => value),
        message.map(value => value),
        targetCustomerId.map(value => value),
        transferType.map(value => value)
      )
    def id: Option[__string]
    def message: Option[__string]
    def targetCustomerId: Option[__string]
    def transferType: Option[zio.aws.medialive.model.InputDeviceTransferType]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getTargetCustomerId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("targetCustomerId", targetCustomerId)
    def getTransferType
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceTransferType] =
      AwsError.unwrapOptionField("transferType", transferType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary
  ) extends zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly {
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val message: Option[__string] =
      scala.Option(impl.message()).map(value => value: __string)
    override val targetCustomerId: Option[__string] =
      scala.Option(impl.targetCustomerId()).map(value => value: __string)
    override val transferType
        : Option[zio.aws.medialive.model.InputDeviceTransferType] = scala
      .Option(impl.transferType())
      .map(value => zio.aws.medialive.model.InputDeviceTransferType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary
  ): zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly =
    new Wrapper(impl)
}
