package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TtmlDestinationSettings(
    styleControl: Option[zio.aws.medialive.model.TtmlDestinationStyleControl] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.TtmlDestinationSettings = {
    import TtmlDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.TtmlDestinationSettings
      .builder()
      .optionallyWith(styleControl.map(value => value.unwrap))(_.styleControl)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly =
    zio.aws.medialive.model.TtmlDestinationSettings.wrap(buildAwsValue())
}
object TtmlDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.TtmlDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.TtmlDestinationSettings =
      zio.aws.medialive.model
        .TtmlDestinationSettings(styleControl.map(value => value))
    def styleControl
        : Option[zio.aws.medialive.model.TtmlDestinationStyleControl]
    def getStyleControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TtmlDestinationStyleControl
    ] = AwsError.unwrapOptionField("styleControl", styleControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.TtmlDestinationSettings
  ) extends zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly {
    override val styleControl
        : Option[zio.aws.medialive.model.TtmlDestinationStyleControl] = scala
      .Option(impl.styleControl())
      .map(value =>
        zio.aws.medialive.model.TtmlDestinationStyleControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.TtmlDestinationSettings
  ): zio.aws.medialive.model.TtmlDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
