package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait TtmlDestinationStyleControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl
}
object TtmlDestinationStyleControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl
  ): zio.aws.medialive.model.TtmlDestinationStyleControl = value match {
    case software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
    case software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.USE_CONFIGURED =>
      val r = USE_CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.TtmlDestinationStyleControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl =
      software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSTHROUGH
      extends zio.aws.medialive.model.TtmlDestinationStyleControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl =
      software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.PASSTHROUGH
  }
  case object USE_CONFIGURED
      extends zio.aws.medialive.model.TtmlDestinationStyleControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl =
      software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl.USE_CONFIGURED
  }
}
