package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UdpContainerSettings(
    m2tsSettings: Option[zio.aws.medialive.model.M2tsSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UdpContainerSettings = {
    import UdpContainerSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UdpContainerSettings
      .builder()
      .optionallyWith(m2tsSettings.map(value => value.buildAwsValue()))(
        _.m2tsSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UdpContainerSettings.ReadOnly =
    zio.aws.medialive.model.UdpContainerSettings.wrap(buildAwsValue())
}
object UdpContainerSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UdpContainerSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UdpContainerSettings =
      zio.aws.medialive.model
        .UdpContainerSettings(m2tsSettings.map(value => value.asEditable))
    def m2tsSettings: Option[zio.aws.medialive.model.M2tsSettings.ReadOnly]
    def getM2tsSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsSettings.ReadOnly] =
      AwsError.unwrapOptionField("m2tsSettings", m2tsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UdpContainerSettings
  ) extends zio.aws.medialive.model.UdpContainerSettings.ReadOnly {
    override val m2tsSettings
        : Option[zio.aws.medialive.model.M2tsSettings.ReadOnly] = scala
      .Option(impl.m2tsSettings())
      .map(value => zio.aws.medialive.model.M2tsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UdpContainerSettings
  ): zio.aws.medialive.model.UdpContainerSettings.ReadOnly = new Wrapper(impl)
}
