package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0
import scala.jdk.CollectionConverters._
final case class UdpGroupSettings(
    inputLossAction: Option[zio.aws.medialive.model.InputLossActionForUdpOut] =
      None,
    timedMetadataId3Frame: Option[
      zio.aws.medialive.model.UdpTimedMetadataId3Frame
    ] = None,
    timedMetadataId3Period: Option[__integerMin0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UdpGroupSettings = {
    import UdpGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UdpGroupSettings
      .builder()
      .optionallyWith(inputLossAction.map(value => value.unwrap))(
        _.inputLossAction
      )
      .optionallyWith(timedMetadataId3Frame.map(value => value.unwrap))(
        _.timedMetadataId3Frame
      )
      .optionallyWith(timedMetadataId3Period.map(value => value: Integer))(
        _.timedMetadataId3Period
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UdpGroupSettings.ReadOnly =
    zio.aws.medialive.model.UdpGroupSettings.wrap(buildAwsValue())
}
object UdpGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UdpGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UdpGroupSettings =
      zio.aws.medialive.model.UdpGroupSettings(
        inputLossAction.map(value => value),
        timedMetadataId3Frame.map(value => value),
        timedMetadataId3Period.map(value => value)
      )
    def inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForUdpOut]
    def timedMetadataId3Frame
        : Option[zio.aws.medialive.model.UdpTimedMetadataId3Frame]
    def timedMetadataId3Period: Option[__integerMin0]
    def getInputLossAction
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLossActionForUdpOut] =
      AwsError.unwrapOptionField("inputLossAction", inputLossAction)
    def getTimedMetadataId3Frame
        : ZIO[Any, AwsError, zio.aws.medialive.model.UdpTimedMetadataId3Frame] =
      AwsError.unwrapOptionField("timedMetadataId3Frame", timedMetadataId3Frame)
    def getTimedMetadataId3Period: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("timedMetadataId3Period", timedMetadataId3Period)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UdpGroupSettings
  ) extends zio.aws.medialive.model.UdpGroupSettings.ReadOnly {
    override val inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForUdpOut] = scala
      .Option(impl.inputLossAction())
      .map(value =>
        zio.aws.medialive.model.InputLossActionForUdpOut.wrap(value)
      )
    override val timedMetadataId3Frame
        : Option[zio.aws.medialive.model.UdpTimedMetadataId3Frame] = scala
      .Option(impl.timedMetadataId3Frame())
      .map(value =>
        zio.aws.medialive.model.UdpTimedMetadataId3Frame.wrap(value)
      )
    override val timedMetadataId3Period: Option[__integerMin0] = scala
      .Option(impl.timedMetadataId3Period())
      .map(value => value: __integerMin0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UdpGroupSettings
  ): zio.aws.medialive.model.UdpGroupSettings.ReadOnly = new Wrapper(impl)
}
