package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0Max10000
import scala.jdk.CollectionConverters._
final case class UdpOutputSettings(
    bufferMsec: Option[__integerMin0Max10000] = None,
    containerSettings: zio.aws.medialive.model.UdpContainerSettings,
    destination: zio.aws.medialive.model.OutputLocationRef,
    fecOutputSettings: Option[zio.aws.medialive.model.FecOutputSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UdpOutputSettings = {
    import UdpOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UdpOutputSettings
      .builder()
      .optionallyWith(bufferMsec.map(value => value: Integer))(_.bufferMsec)
      .containerSettings(containerSettings.buildAwsValue())
      .destination(destination.buildAwsValue())
      .optionallyWith(fecOutputSettings.map(value => value.buildAwsValue()))(
        _.fecOutputSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UdpOutputSettings.ReadOnly =
    zio.aws.medialive.model.UdpOutputSettings.wrap(buildAwsValue())
}
object UdpOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UdpOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UdpOutputSettings =
      zio.aws.medialive.model.UdpOutputSettings(
        bufferMsec.map(value => value),
        containerSettings.asEditable,
        destination.asEditable,
        fecOutputSettings.map(value => value.asEditable)
      )
    def bufferMsec: Option[__integerMin0Max10000]
    def containerSettings: zio.aws.medialive.model.UdpContainerSettings.ReadOnly
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def fecOutputSettings
        : Option[zio.aws.medialive.model.FecOutputSettings.ReadOnly]
    def getBufferMsec: ZIO[Any, AwsError, __integerMin0Max10000] =
      AwsError.unwrapOptionField("bufferMsec", bufferMsec)
    def getContainerSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.UdpContainerSettings.ReadOnly
    ] = ZIO.succeed(containerSettings)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getFecOutputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FecOutputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("fecOutputSettings", fecOutputSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UdpOutputSettings
  ) extends zio.aws.medialive.model.UdpOutputSettings.ReadOnly {
    override val bufferMsec: Option[__integerMin0Max10000] =
      scala.Option(impl.bufferMsec()).map(value => value: __integerMin0Max10000)
    override val containerSettings
        : zio.aws.medialive.model.UdpContainerSettings.ReadOnly =
      zio.aws.medialive.model.UdpContainerSettings
        .wrap(impl.containerSettings())
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val fecOutputSettings
        : Option[zio.aws.medialive.model.FecOutputSettings.ReadOnly] = scala
      .Option(impl.fecOutputSettings())
      .map(value => zio.aws.medialive.model.FecOutputSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UdpOutputSettings
  ): zio.aws.medialive.model.UdpOutputSettings.ReadOnly = new Wrapper(impl)
}
