package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateChannelClassRequest(
    channelClass: zio.aws.medialive.model.ChannelClass,
    channelId: __string,
    destinations: Option[Iterable[zio.aws.medialive.model.OutputDestination]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest = {
    import UpdateChannelClassRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest
      .builder()
      .channelClass(channelClass.unwrap)
      .channelId(channelId: java.lang.String)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateChannelClassRequest.ReadOnly =
    zio.aws.medialive.model.UpdateChannelClassRequest.wrap(buildAwsValue())
}
object UpdateChannelClassRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateChannelClassRequest =
      zio.aws.medialive.model.UpdateChannelClassRequest(
        channelClass,
        channelId,
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelClass: zio.aws.medialive.model.ChannelClass
    def channelId: __string
    def destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]]
    def getChannelClass
        : ZIO[Any, Nothing, zio.aws.medialive.model.ChannelClass] =
      ZIO.succeed(channelClass)
    def getChannelId: ZIO[Any, Nothing, __string] = ZIO.succeed(channelId)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.OutputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest
  ) extends zio.aws.medialive.model.UpdateChannelClassRequest.ReadOnly {
    override val channelClass: zio.aws.medialive.model.ChannelClass =
      zio.aws.medialive.model.ChannelClass.wrap(impl.channelClass())
    override val channelId: __string = impl.channelId(): __string
    override val destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]] =
      scala
        .Option(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.OutputDestination.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest
  ): zio.aws.medialive.model.UpdateChannelClassRequest.ReadOnly = new Wrapper(
    impl
  )
}
