package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    cdiInputSpecification: Option[
      zio.aws.medialive.model.CdiInputSpecification
    ] = None,
    channelId: __string,
    destinations: Option[Iterable[zio.aws.medialive.model.OutputDestination]] =
      None,
    encoderSettings: Option[zio.aws.medialive.model.EncoderSettings] = None,
    inputAttachments: Option[
      Iterable[zio.aws.medialive.model.InputAttachment]
    ] = None,
    inputSpecification: Option[zio.aws.medialive.model.InputSpecification] =
      None,
    logLevel: Option[zio.aws.medialive.model.LogLevel] = None,
    maintenance: Option[zio.aws.medialive.model.MaintenanceUpdateSettings] =
      None,
    name: Option[__string] = None,
    roleArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateChannelRequest
      .builder()
      .optionallyWith(
        cdiInputSpecification.map(value => value.buildAwsValue())
      )(_.cdiInputSpecification)
      .channelId(channelId: java.lang.String)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(encoderSettings.map(value => value.buildAwsValue()))(
        _.encoderSettings
      )
      .optionallyWith(
        inputAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputAttachments)
      .optionallyWith(inputSpecification.map(value => value.buildAwsValue()))(
        _.inputSpecification
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(maintenance.map(value => value.buildAwsValue()))(
        _.maintenance
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateChannelRequest.ReadOnly =
    zio.aws.medialive.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateChannelRequest =
      zio.aws.medialive.model.UpdateChannelRequest(
        cdiInputSpecification.map(value => value.asEditable),
        channelId,
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encoderSettings.map(value => value.asEditable),
        inputAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputSpecification.map(value => value.asEditable),
        logLevel.map(value => value),
        maintenance.map(value => value.asEditable),
        name.map(value => value),
        roleArn.map(value => value)
      )
    def cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly]
    def channelId: __string
    def destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]]
    def encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly]
    def inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]]
    def inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly]
    def logLevel: Option[zio.aws.medialive.model.LogLevel]
    def maintenance
        : Option[zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly]
    def name: Option[__string]
    def roleArn: Option[__string]
    def getCdiInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.CdiInputSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("cdiInputSpecification", cdiInputSpecification)
    def getChannelId: ZIO[Any, Nothing, __string] = ZIO.succeed(channelId)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.OutputDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getEncoderSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.EncoderSettings.ReadOnly] =
      AwsError.unwrapOptionField("encoderSettings", encoderSettings)
    def getInputAttachments: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("inputAttachments", inputAttachments)
    def getInputSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("inputSpecification", inputSpecification)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.medialive.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getMaintenance: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly
    ] = AwsError.unwrapOptionField("maintenance", maintenance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelRequest
  ) extends zio.aws.medialive.model.UpdateChannelRequest.ReadOnly {
    override val cdiInputSpecification
        : Option[zio.aws.medialive.model.CdiInputSpecification.ReadOnly] = scala
      .Option(impl.cdiInputSpecification())
      .map(value => zio.aws.medialive.model.CdiInputSpecification.wrap(value))
    override val channelId: __string = impl.channelId(): __string
    override val destinations
        : Option[List[zio.aws.medialive.model.OutputDestination.ReadOnly]] =
      scala
        .Option(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.OutputDestination.wrap(item)
          }.toList
        )
    override val encoderSettings
        : Option[zio.aws.medialive.model.EncoderSettings.ReadOnly] = scala
      .Option(impl.encoderSettings())
      .map(value => zio.aws.medialive.model.EncoderSettings.wrap(value))
    override val inputAttachments
        : Option[List[zio.aws.medialive.model.InputAttachment.ReadOnly]] = scala
      .Option(impl.inputAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputAttachment.wrap(item)
        }.toList
      )
    override val inputSpecification
        : Option[zio.aws.medialive.model.InputSpecification.ReadOnly] = scala
      .Option(impl.inputSpecification())
      .map(value => zio.aws.medialive.model.InputSpecification.wrap(value))
    override val logLevel: Option[zio.aws.medialive.model.LogLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.medialive.model.LogLevel.wrap(value))
    override val maintenance
        : Option[zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly] =
      scala
        .Option(impl.maintenance())
        .map(value =>
          zio.aws.medialive.model.MaintenanceUpdateSettings.wrap(value)
        )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelRequest
  ): zio.aws.medialive.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
