package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateChannelResponse(
    channel: Option[zio.aws.medialive.model.Channel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateChannelResponse.ReadOnly =
    zio.aws.medialive.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateChannelResponse =
      zio.aws.medialive.model
        .UpdateChannelResponse(channel.map(value => value.asEditable))
    def channel: Option[zio.aws.medialive.model.Channel.ReadOnly]
    def getChannel
        : ZIO[Any, AwsError, zio.aws.medialive.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelResponse
  ) extends zio.aws.medialive.model.UpdateChannelResponse.ReadOnly {
    override val channel: Option[zio.aws.medialive.model.Channel.ReadOnly] =
      scala
        .Option(impl.channel())
        .map(value => zio.aws.medialive.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateChannelResponse
  ): zio.aws.medialive.model.UpdateChannelResponse.ReadOnly = new Wrapper(impl)
}
