package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateInputDeviceRequest(
    hdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings
    ] = None,
    inputDeviceId: __string,
    name: Option[__string] = None,
    uhdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest = {
    import UpdateInputDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest
      .builder()
      .optionallyWith(hdDeviceSettings.map(value => value.buildAwsValue()))(
        _.hdDeviceSettings
      )
      .inputDeviceId(inputDeviceId: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(uhdDeviceSettings.map(value => value.buildAwsValue()))(
        _.uhdDeviceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateInputDeviceRequest.ReadOnly =
    zio.aws.medialive.model.UpdateInputDeviceRequest.wrap(buildAwsValue())
}
object UpdateInputDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateInputDeviceRequest =
      zio.aws.medialive.model.UpdateInputDeviceRequest(
        hdDeviceSettings.map(value => value.asEditable),
        inputDeviceId,
        name.map(value => value),
        uhdDeviceSettings.map(value => value.asEditable)
      )
    def hdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ]
    def inputDeviceId: __string
    def name: Option[__string]
    def uhdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ]
    def getHdDeviceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hdDeviceSettings", hdDeviceSettings)
    def getInputDeviceId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(inputDeviceId)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getUhdDeviceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ] = AwsError.unwrapOptionField("uhdDeviceSettings", uhdDeviceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest
  ) extends zio.aws.medialive.model.UpdateInputDeviceRequest.ReadOnly {
    override val hdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ] = scala
      .Option(impl.hdDeviceSettings())
      .map(value =>
        zio.aws.medialive.model.InputDeviceConfigurableSettings.wrap(value)
      )
    override val inputDeviceId: __string = impl.inputDeviceId(): __string
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val uhdDeviceSettings: Option[
      zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly
    ] = scala
      .Option(impl.uhdDeviceSettings())
      .map(value =>
        zio.aws.medialive.model.InputDeviceConfigurableSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest
  ): zio.aws.medialive.model.UpdateInputDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
