package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateInputDeviceResponse(
    arn: Option[__string] = None,
    connectionState: Option[
      zio.aws.medialive.model.InputDeviceConnectionState
    ] = None,
    deviceSettingsSyncState: Option[
      zio.aws.medialive.model.DeviceSettingsSyncState
    ] = None,
    deviceUpdateStatus: Option[zio.aws.medialive.model.DeviceUpdateStatus] =
      None,
    hdDeviceSettings: Option[zio.aws.medialive.model.InputDeviceHdSettings] =
      None,
    id: Option[__string] = None,
    macAddress: Option[__string] = None,
    name: Option[__string] = None,
    networkSettings: Option[
      zio.aws.medialive.model.InputDeviceNetworkSettings
    ] = None,
    serialNumber: Option[__string] = None,
    `type`: Option[zio.aws.medialive.model.InputDeviceType] = None,
    uhdDeviceSettings: Option[zio.aws.medialive.model.InputDeviceUhdSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse = {
    import UpdateInputDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(deviceSettingsSyncState.map(value => value.unwrap))(
        _.deviceSettingsSyncState
      )
      .optionallyWith(deviceUpdateStatus.map(value => value.unwrap))(
        _.deviceUpdateStatus
      )
      .optionallyWith(hdDeviceSettings.map(value => value.buildAwsValue()))(
        _.hdDeviceSettings
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(networkSettings.map(value => value.buildAwsValue()))(
        _.networkSettings
      )
      .optionallyWith(serialNumber.map(value => value: java.lang.String))(
        _.serialNumber
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(uhdDeviceSettings.map(value => value.buildAwsValue()))(
        _.uhdDeviceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly =
    zio.aws.medialive.model.UpdateInputDeviceResponse.wrap(buildAwsValue())
}
object UpdateInputDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateInputDeviceResponse =
      zio.aws.medialive.model.UpdateInputDeviceResponse(
        arn.map(value => value),
        connectionState.map(value => value),
        deviceSettingsSyncState.map(value => value),
        deviceUpdateStatus.map(value => value),
        hdDeviceSettings.map(value => value.asEditable),
        id.map(value => value),
        macAddress.map(value => value),
        name.map(value => value),
        networkSettings.map(value => value.asEditable),
        serialNumber.map(value => value),
        `type`.map(value => value),
        uhdDeviceSettings.map(value => value.asEditable)
      )
    def arn: Option[__string]
    def connectionState
        : Option[zio.aws.medialive.model.InputDeviceConnectionState]
    def deviceSettingsSyncState
        : Option[zio.aws.medialive.model.DeviceSettingsSyncState]
    def deviceUpdateStatus: Option[zio.aws.medialive.model.DeviceUpdateStatus]
    def hdDeviceSettings
        : Option[zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly]
    def id: Option[__string]
    def macAddress: Option[__string]
    def name: Option[__string]
    def networkSettings
        : Option[zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly]
    def serialNumber: Option[__string]
    def `type`: Option[zio.aws.medialive.model.InputDeviceType]
    def uhdDeviceSettings
        : Option[zio.aws.medialive.model.InputDeviceUhdSettings.ReadOnly]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getConnectionState: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceConnectionState
    ] = AwsError.unwrapOptionField("connectionState", connectionState)
    def getDeviceSettingsSyncState
        : ZIO[Any, AwsError, zio.aws.medialive.model.DeviceSettingsSyncState] =
      AwsError.unwrapOptionField(
        "deviceSettingsSyncState",
        deviceSettingsSyncState
      )
    def getDeviceUpdateStatus
        : ZIO[Any, AwsError, zio.aws.medialive.model.DeviceUpdateStatus] =
      AwsError.unwrapOptionField("deviceUpdateStatus", deviceUpdateStatus)
    def getHdDeviceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hdDeviceSettings", hdDeviceSettings)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMacAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly
    ] = AwsError.unwrapOptionField("networkSettings", networkSettings)
    def getSerialNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getType: ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUhdDeviceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceUhdSettings.ReadOnly
    ] = AwsError.unwrapOptionField("uhdDeviceSettings", uhdDeviceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse
  ) extends zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val connectionState
        : Option[zio.aws.medialive.model.InputDeviceConnectionState] = scala
      .Option(impl.connectionState())
      .map(value =>
        zio.aws.medialive.model.InputDeviceConnectionState.wrap(value)
      )
    override val deviceSettingsSyncState
        : Option[zio.aws.medialive.model.DeviceSettingsSyncState] = scala
      .Option(impl.deviceSettingsSyncState())
      .map(value => zio.aws.medialive.model.DeviceSettingsSyncState.wrap(value))
    override val deviceUpdateStatus
        : Option[zio.aws.medialive.model.DeviceUpdateStatus] = scala
      .Option(impl.deviceUpdateStatus())
      .map(value => zio.aws.medialive.model.DeviceUpdateStatus.wrap(value))
    override val hdDeviceSettings
        : Option[zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly] = scala
      .Option(impl.hdDeviceSettings())
      .map(value => zio.aws.medialive.model.InputDeviceHdSettings.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val macAddress: Option[__string] =
      scala.Option(impl.macAddress()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val networkSettings
        : Option[zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly] =
      scala
        .Option(impl.networkSettings())
        .map(value =>
          zio.aws.medialive.model.InputDeviceNetworkSettings.wrap(value)
        )
    override val serialNumber: Option[__string] =
      scala.Option(impl.serialNumber()).map(value => value: __string)
    override val `type`: Option[zio.aws.medialive.model.InputDeviceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.medialive.model.InputDeviceType.wrap(value))
    override val uhdDeviceSettings
        : Option[zio.aws.medialive.model.InputDeviceUhdSettings.ReadOnly] =
      scala
        .Option(impl.uhdDeviceSettings())
        .map(value =>
          zio.aws.medialive.model.InputDeviceUhdSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse
  ): zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
