package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateInputRequest(
    destinations: Option[
      Iterable[zio.aws.medialive.model.InputDestinationRequest]
    ] = None,
    inputDevices: Option[Iterable[zio.aws.medialive.model.InputDeviceRequest]] =
      None,
    inputId: __string,
    inputSecurityGroups: Option[Iterable[__string]] = None,
    mediaConnectFlows: Option[
      Iterable[zio.aws.medialive.model.MediaConnectFlowRequest]
    ] = None,
    name: Option[__string] = None,
    roleArn: Option[__string] = None,
    sources: Option[Iterable[zio.aws.medialive.model.InputSourceRequest]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateInputRequest = {
    import UpdateInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateInputRequest
      .builder()
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        inputDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDevices)
      .inputId(inputId: java.lang.String)
      .optionallyWith(
        inputSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputSecurityGroups)
      .optionallyWith(
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaConnectFlows)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateInputRequest.ReadOnly =
    zio.aws.medialive.model.UpdateInputRequest.wrap(buildAwsValue())
}
object UpdateInputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateInputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateInputRequest =
      zio.aws.medialive.model.UpdateInputRequest(
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputId,
        inputSecurityGroups.map(value => value),
        mediaConnectFlows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        roleArn.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def destinations
        : Option[List[zio.aws.medialive.model.InputDestinationRequest.ReadOnly]]
    def inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceRequest.ReadOnly]]
    def inputId: __string
    def inputSecurityGroups: Option[List[__string]]
    def mediaConnectFlows
        : Option[List[zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly]]
    def name: Option[__string]
    def roleArn: Option[__string]
    def sources
        : Option[List[zio.aws.medialive.model.InputSourceRequest.ReadOnly]]
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDestinationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getInputDevices: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDeviceRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDevices", inputDevices)
    def getInputId: ZIO[Any, Nothing, __string] = ZIO.succeed(inputId)
    def getInputSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputSecurityGroups", inputSecurityGroups)
    def getMediaConnectFlows: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaConnectFlows", mediaConnectFlows)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputSourceRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputRequest
  ) extends zio.aws.medialive.model.UpdateInputRequest.ReadOnly {
    override val destinations: Option[
      List[zio.aws.medialive.model.InputDestinationRequest.ReadOnly]
    ] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputDestinationRequest.wrap(item)
        }.toList
      )
    override val inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceRequest.ReadOnly]] =
      scala
        .Option(impl.inputDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputDeviceRequest.wrap(item)
          }.toList
        )
    override val inputId: __string = impl.inputId(): __string
    override val inputSecurityGroups: Option[List[__string]] = scala
      .Option(impl.inputSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val mediaConnectFlows: Option[
      List[zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly]
    ] = scala
      .Option(impl.mediaConnectFlows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MediaConnectFlowRequest.wrap(item)
        }.toList
      )
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val roleArn: Option[__string] =
      scala.Option(impl.roleArn()).map(value => value: __string)
    override val sources
        : Option[List[zio.aws.medialive.model.InputSourceRequest.ReadOnly]] =
      scala
        .Option(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputSourceRequest.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputRequest
  ): zio.aws.medialive.model.UpdateInputRequest.ReadOnly = new Wrapper(impl)
}
