package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateInputSecurityGroupRequest(
    inputSecurityGroupId: __string,
    tags: Option[Map[__string, __string]] = None,
    whitelistRules: Option[
      Iterable[zio.aws.medialive.model.InputWhitelistRuleCidr]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest = {
    import UpdateInputSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest
      .builder()
      .inputSecurityGroupId(inputSecurityGroupId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        whitelistRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whitelistRules)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.UpdateInputSecurityGroupRequest.ReadOnly =
    zio.aws.medialive.model.UpdateInputSecurityGroupRequest
      .wrap(buildAwsValue())
}
object UpdateInputSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateInputSecurityGroupRequest =
      zio.aws.medialive.model.UpdateInputSecurityGroupRequest(
        inputSecurityGroupId,
        tags.map(value => value),
        whitelistRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputSecurityGroupId: __string
    def tags: Option[Map[__string, __string]]
    def whitelistRules
        : Option[List[zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly]]
    def getInputSecurityGroupId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(inputSecurityGroupId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWhitelistRules: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly
    ]] = AwsError.unwrapOptionField("whitelistRules", whitelistRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest
  ) extends zio.aws.medialive.model.UpdateInputSecurityGroupRequest.ReadOnly {
    override val inputSecurityGroupId: __string =
      impl.inputSecurityGroupId(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val whitelistRules: Option[
      List[zio.aws.medialive.model.InputWhitelistRuleCidr.ReadOnly]
    ] = scala
      .Option(impl.whitelistRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.InputWhitelistRuleCidr.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest
  ): zio.aws.medialive.model.UpdateInputSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
