package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateInputSecurityGroupResponse(
    securityGroup: Option[zio.aws.medialive.model.InputSecurityGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse = {
    import UpdateInputSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse
      .builder()
      .optionallyWith(securityGroup.map(value => value.buildAwsValue()))(
        _.securityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly =
    zio.aws.medialive.model.UpdateInputSecurityGroupResponse
      .wrap(buildAwsValue())
}
object UpdateInputSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateInputSecurityGroupResponse =
      zio.aws.medialive.model.UpdateInputSecurityGroupResponse(
        securityGroup.map(value => value.asEditable)
      )
    def securityGroup
        : Option[zio.aws.medialive.model.InputSecurityGroup.ReadOnly]
    def getSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroup", securityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse
  ) extends zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly {
    override val securityGroup
        : Option[zio.aws.medialive.model.InputSecurityGroup.ReadOnly] = scala
      .Option(impl.securityGroup())
      .map(value => zio.aws.medialive.model.InputSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse
  ): zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
