package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateMultiplexProgramRequest(
    multiplexId: __string,
    multiplexProgramSettings: Option[
      zio.aws.medialive.model.MultiplexProgramSettings
    ] = None,
    programName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest = {
    import UpdateMultiplexProgramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest
      .builder()
      .multiplexId(multiplexId: java.lang.String)
      .optionallyWith(
        multiplexProgramSettings.map(value => value.buildAwsValue())
      )(_.multiplexProgramSettings)
      .programName(programName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.UpdateMultiplexProgramRequest.ReadOnly =
    zio.aws.medialive.model.UpdateMultiplexProgramRequest.wrap(buildAwsValue())
}
object UpdateMultiplexProgramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateMultiplexProgramRequest =
      zio.aws.medialive.model.UpdateMultiplexProgramRequest(
        multiplexId,
        multiplexProgramSettings.map(value => value.asEditable),
        programName
      )
    def multiplexId: __string
    def multiplexProgramSettings
        : Option[zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly]
    def programName: __string
    def getMultiplexId: ZIO[Any, Nothing, __string] = ZIO.succeed(multiplexId)
    def getMultiplexProgramSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiplexProgramSettings",
      multiplexProgramSettings
    )
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest
  ) extends zio.aws.medialive.model.UpdateMultiplexProgramRequest.ReadOnly {
    override val multiplexId: __string = impl.multiplexId(): __string
    override val multiplexProgramSettings
        : Option[zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly] =
      scala
        .Option(impl.multiplexProgramSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexProgramSettings.wrap(value)
        )
    override val programName: __string = impl.programName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest
  ): zio.aws.medialive.model.UpdateMultiplexProgramRequest.ReadOnly =
    new Wrapper(impl)
}
