package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateMultiplexRequest(
    multiplexId: __string,
    multiplexSettings: Option[zio.aws.medialive.model.MultiplexSettings] = None,
    name: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest = {
    import UpdateMultiplexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest
      .builder()
      .multiplexId(multiplexId: java.lang.String)
      .optionallyWith(multiplexSettings.map(value => value.buildAwsValue()))(
        _.multiplexSettings
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateMultiplexRequest.ReadOnly =
    zio.aws.medialive.model.UpdateMultiplexRequest.wrap(buildAwsValue())
}
object UpdateMultiplexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateMultiplexRequest =
      zio.aws.medialive.model.UpdateMultiplexRequest(
        multiplexId,
        multiplexSettings.map(value => value.asEditable),
        name.map(value => value)
      )
    def multiplexId: __string
    def multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettings.ReadOnly]
    def name: Option[__string]
    def getMultiplexId: ZIO[Any, Nothing, __string] = ZIO.succeed(multiplexId)
    def getMultiplexSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexSettings.ReadOnly
    ] = AwsError.unwrapOptionField("multiplexSettings", multiplexSettings)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest
  ) extends zio.aws.medialive.model.UpdateMultiplexRequest.ReadOnly {
    override val multiplexId: __string = impl.multiplexId(): __string
    override val multiplexSettings
        : Option[zio.aws.medialive.model.MultiplexSettings.ReadOnly] = scala
      .Option(impl.multiplexSettings())
      .map(value => zio.aws.medialive.model.MultiplexSettings.wrap(value))
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest
  ): zio.aws.medialive.model.UpdateMultiplexRequest.ReadOnly = new Wrapper(impl)
}
