package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMultiplexResponse(
    multiplex: Option[zio.aws.medialive.model.Multiplex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse = {
    import UpdateMultiplexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse
      .builder()
      .optionallyWith(multiplex.map(value => value.buildAwsValue()))(
        _.multiplex
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly =
    zio.aws.medialive.model.UpdateMultiplexResponse.wrap(buildAwsValue())
}
object UpdateMultiplexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateMultiplexResponse =
      zio.aws.medialive.model
        .UpdateMultiplexResponse(multiplex.map(value => value.asEditable))
    def multiplex: Option[zio.aws.medialive.model.Multiplex.ReadOnly]
    def getMultiplex
        : ZIO[Any, AwsError, zio.aws.medialive.model.Multiplex.ReadOnly] =
      AwsError.unwrapOptionField("multiplex", multiplex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse
  ) extends zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly {
    override val multiplex: Option[zio.aws.medialive.model.Multiplex.ReadOnly] =
      scala
        .Option(impl.multiplex())
        .map(value => zio.aws.medialive.model.Multiplex.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse
  ): zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly = new Wrapper(
    impl
  )
}
