package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateReservationRequest(
    name: Option[__string] = None,
    reservationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateReservationRequest = {
    import UpdateReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateReservationRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .reservationId(reservationId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateReservationRequest.ReadOnly =
    zio.aws.medialive.model.UpdateReservationRequest.wrap(buildAwsValue())
}
object UpdateReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateReservationRequest =
      zio.aws.medialive.model
        .UpdateReservationRequest(name.map(value => value), reservationId)
    def name: Option[__string]
    def reservationId: __string
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getReservationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(reservationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateReservationRequest
  ) extends zio.aws.medialive.model.UpdateReservationRequest.ReadOnly {
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val reservationId: __string = impl.reservationId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateReservationRequest
  ): zio.aws.medialive.model.UpdateReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
