package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateReservationResponse(
    reservation: Option[zio.aws.medialive.model.Reservation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.UpdateReservationResponse = {
    import UpdateReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.UpdateReservationResponse
      .builder()
      .optionallyWith(reservation.map(value => value.buildAwsValue()))(
        _.reservation
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.UpdateReservationResponse.ReadOnly =
    zio.aws.medialive.model.UpdateReservationResponse.wrap(buildAwsValue())
}
object UpdateReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.UpdateReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.UpdateReservationResponse =
      zio.aws.medialive.model
        .UpdateReservationResponse(reservation.map(value => value.asEditable))
    def reservation: Option[zio.aws.medialive.model.Reservation.ReadOnly]
    def getReservation
        : ZIO[Any, AwsError, zio.aws.medialive.model.Reservation.ReadOnly] =
      AwsError.unwrapOptionField("reservation", reservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.UpdateReservationResponse
  ) extends zio.aws.medialive.model.UpdateReservationResponse.ReadOnly {
    override val reservation
        : Option[zio.aws.medialive.model.Reservation.ReadOnly] = scala
      .Option(impl.reservation())
      .map(value => zio.aws.medialive.model.Reservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.UpdateReservationResponse
  ): zio.aws.medialive.model.UpdateReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
