package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin1000, __doubleMin0Max1}
import scala.jdk.CollectionConverters._
final case class VideoBlackFailoverSettings(
    blackDetectThreshold: Option[__doubleMin0Max1] = None,
    videoBlackThresholdMsec: Option[__integerMin1000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings = {
    import VideoBlackFailoverSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings
      .builder()
      .optionallyWith(
        blackDetectThreshold.map(value => value: java.lang.Double)
      )(_.blackDetectThreshold)
      .optionallyWith(videoBlackThresholdMsec.map(value => value: Integer))(
        _.videoBlackThresholdMsec
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly =
    zio.aws.medialive.model.VideoBlackFailoverSettings.wrap(buildAwsValue())
}
object VideoBlackFailoverSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoBlackFailoverSettings =
      zio.aws.medialive.model.VideoBlackFailoverSettings(
        blackDetectThreshold.map(value => value),
        videoBlackThresholdMsec.map(value => value)
      )
    def blackDetectThreshold: Option[__doubleMin0Max1]
    def videoBlackThresholdMsec: Option[__integerMin1000]
    def getBlackDetectThreshold: ZIO[Any, AwsError, __doubleMin0Max1] =
      AwsError.unwrapOptionField("blackDetectThreshold", blackDetectThreshold)
    def getVideoBlackThresholdMsec: ZIO[Any, AwsError, __integerMin1000] =
      AwsError.unwrapOptionField(
        "videoBlackThresholdMsec",
        videoBlackThresholdMsec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings
  ) extends zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly {
    override val blackDetectThreshold: Option[__doubleMin0Max1] = scala
      .Option(impl.blackDetectThreshold())
      .map(value => value: __doubleMin0Max1)
    override val videoBlackThresholdMsec: Option[__integerMin1000] = scala
      .Option(impl.videoBlackThresholdMsec())
      .map(value => value: __integerMin1000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings
  ): zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly = new Wrapper(
    impl
  )
}
