package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoCodecSettings(
    frameCaptureSettings: Option[zio.aws.medialive.model.FrameCaptureSettings] =
      None,
    h264Settings: Option[zio.aws.medialive.model.H264Settings] = None,
    h265Settings: Option[zio.aws.medialive.model.H265Settings] = None,
    mpeg2Settings: Option[zio.aws.medialive.model.Mpeg2Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoCodecSettings = {
    import VideoCodecSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoCodecSettings
      .builder()
      .optionallyWith(frameCaptureSettings.map(value => value.buildAwsValue()))(
        _.frameCaptureSettings
      )
      .optionallyWith(h264Settings.map(value => value.buildAwsValue()))(
        _.h264Settings
      )
      .optionallyWith(h265Settings.map(value => value.buildAwsValue()))(
        _.h265Settings
      )
      .optionallyWith(mpeg2Settings.map(value => value.buildAwsValue()))(
        _.mpeg2Settings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoCodecSettings.ReadOnly =
    zio.aws.medialive.model.VideoCodecSettings.wrap(buildAwsValue())
}
object VideoCodecSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoCodecSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoCodecSettings =
      zio.aws.medialive.model.VideoCodecSettings(
        frameCaptureSettings.map(value => value.asEditable),
        h264Settings.map(value => value.asEditable),
        h265Settings.map(value => value.asEditable),
        mpeg2Settings.map(value => value.asEditable)
      )
    def frameCaptureSettings
        : Option[zio.aws.medialive.model.FrameCaptureSettings.ReadOnly]
    def h264Settings: Option[zio.aws.medialive.model.H264Settings.ReadOnly]
    def h265Settings: Option[zio.aws.medialive.model.H265Settings.ReadOnly]
    def mpeg2Settings: Option[zio.aws.medialive.model.Mpeg2Settings.ReadOnly]
    def getFrameCaptureSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureSettings.ReadOnly
    ] = AwsError.unwrapOptionField("frameCaptureSettings", frameCaptureSettings)
    def getH264Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264Settings.ReadOnly] =
      AwsError.unwrapOptionField("h264Settings", h264Settings)
    def getH265Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.H265Settings.ReadOnly] =
      AwsError.unwrapOptionField("h265Settings", h265Settings)
    def getMpeg2Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2Settings.ReadOnly] =
      AwsError.unwrapOptionField("mpeg2Settings", mpeg2Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoCodecSettings
  ) extends zio.aws.medialive.model.VideoCodecSettings.ReadOnly {
    override val frameCaptureSettings
        : Option[zio.aws.medialive.model.FrameCaptureSettings.ReadOnly] = scala
      .Option(impl.frameCaptureSettings())
      .map(value => zio.aws.medialive.model.FrameCaptureSettings.wrap(value))
    override val h264Settings
        : Option[zio.aws.medialive.model.H264Settings.ReadOnly] = scala
      .Option(impl.h264Settings())
      .map(value => zio.aws.medialive.model.H264Settings.wrap(value))
    override val h265Settings
        : Option[zio.aws.medialive.model.H265Settings.ReadOnly] = scala
      .Option(impl.h265Settings())
      .map(value => zio.aws.medialive.model.H265Settings.wrap(value))
    override val mpeg2Settings
        : Option[zio.aws.medialive.model.Mpeg2Settings.ReadOnly] = scala
      .Option(impl.mpeg2Settings())
      .map(value => zio.aws.medialive.model.Mpeg2Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoCodecSettings
  ): zio.aws.medialive.model.VideoCodecSettings.ReadOnly = new Wrapper(impl)
}
