package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max100,
  __string,
  __integer
}
import scala.jdk.CollectionConverters._
final case class VideoDescription(
    codecSettings: Option[zio.aws.medialive.model.VideoCodecSettings] = None,
    height: Option[__integer] = None,
    name: __string,
    respondToAfd: Option[zio.aws.medialive.model.VideoDescriptionRespondToAfd] =
      None,
    scalingBehavior: Option[
      zio.aws.medialive.model.VideoDescriptionScalingBehavior
    ] = None,
    sharpness: Option[__integerMin0Max100] = None,
    width: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoDescription = {
    import VideoDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoDescription
      .builder()
      .optionallyWith(codecSettings.map(value => value.buildAwsValue()))(
        _.codecSettings
      )
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .name(name: java.lang.String)
      .optionallyWith(respondToAfd.map(value => value.unwrap))(_.respondToAfd)
      .optionallyWith(scalingBehavior.map(value => value.unwrap))(
        _.scalingBehavior
      )
      .optionallyWith(sharpness.map(value => value: Integer))(_.sharpness)
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoDescription.ReadOnly =
    zio.aws.medialive.model.VideoDescription.wrap(buildAwsValue())
}
object VideoDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoDescription =
      zio.aws.medialive.model.VideoDescription(
        codecSettings.map(value => value.asEditable),
        height.map(value => value),
        name,
        respondToAfd.map(value => value),
        scalingBehavior.map(value => value),
        sharpness.map(value => value),
        width.map(value => value)
      )
    def codecSettings
        : Option[zio.aws.medialive.model.VideoCodecSettings.ReadOnly]
    def height: Option[__integer]
    def name: __string
    def respondToAfd
        : Option[zio.aws.medialive.model.VideoDescriptionRespondToAfd]
    def scalingBehavior
        : Option[zio.aws.medialive.model.VideoDescriptionScalingBehavior]
    def sharpness: Option[__integerMin0Max100]
    def width: Option[__integer]
    def getCodecSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoCodecSettings.ReadOnly
    ] = AwsError.unwrapOptionField("codecSettings", codecSettings)
    def getHeight: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("height", height)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getRespondToAfd: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoDescriptionRespondToAfd
    ] = AwsError.unwrapOptionField("respondToAfd", respondToAfd)
    def getScalingBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoDescriptionScalingBehavior
    ] = AwsError.unwrapOptionField("scalingBehavior", scalingBehavior)
    def getSharpness: ZIO[Any, AwsError, __integerMin0Max100] =
      AwsError.unwrapOptionField("sharpness", sharpness)
    def getWidth: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("width", width)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoDescription
  ) extends zio.aws.medialive.model.VideoDescription.ReadOnly {
    override val codecSettings
        : Option[zio.aws.medialive.model.VideoCodecSettings.ReadOnly] = scala
      .Option(impl.codecSettings())
      .map(value => zio.aws.medialive.model.VideoCodecSettings.wrap(value))
    override val height: Option[__integer] =
      scala.Option(impl.height()).map(value => value: __integer)
    override val name: __string = impl.name(): __string
    override val respondToAfd
        : Option[zio.aws.medialive.model.VideoDescriptionRespondToAfd] = scala
      .Option(impl.respondToAfd())
      .map(value =>
        zio.aws.medialive.model.VideoDescriptionRespondToAfd.wrap(value)
      )
    override val scalingBehavior
        : Option[zio.aws.medialive.model.VideoDescriptionScalingBehavior] =
      scala
        .Option(impl.scalingBehavior())
        .map(value =>
          zio.aws.medialive.model.VideoDescriptionScalingBehavior.wrap(value)
        )
    override val sharpness: Option[__integerMin0Max100] =
      scala.Option(impl.sharpness()).map(value => value: __integerMin0Max100)
    override val width: Option[__integer] =
      scala.Option(impl.width()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoDescription
  ): zio.aws.medialive.model.VideoDescription.ReadOnly = new Wrapper(impl)
}
