package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait VideoDescriptionScalingBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior
}
object VideoDescriptionScalingBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior
  ): zio.aws.medialive.model.VideoDescriptionScalingBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.STRETCH_TO_OUTPUT =>
      val r = STRETCH_TO_OUTPUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.VideoDescriptionScalingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior =
      software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT
      extends zio.aws.medialive.model.VideoDescriptionScalingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior =
      software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.DEFAULT
  }
  case object STRETCH_TO_OUTPUT
      extends zio.aws.medialive.model.VideoDescriptionScalingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior =
      software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior.STRETCH_TO_OUTPUT
  }
}
