package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoSelector(
    colorSpace: Option[zio.aws.medialive.model.VideoSelectorColorSpace] = None,
    colorSpaceSettings: Option[
      zio.aws.medialive.model.VideoSelectorColorSpaceSettings
    ] = None,
    colorSpaceUsage: Option[
      zio.aws.medialive.model.VideoSelectorColorSpaceUsage
    ] = None,
    selectorSettings: Option[zio.aws.medialive.model.VideoSelectorSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoSelector = {
    import VideoSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoSelector
      .builder()
      .optionallyWith(colorSpace.map(value => value.unwrap))(_.colorSpace)
      .optionallyWith(colorSpaceSettings.map(value => value.buildAwsValue()))(
        _.colorSpaceSettings
      )
      .optionallyWith(colorSpaceUsage.map(value => value.unwrap))(
        _.colorSpaceUsage
      )
      .optionallyWith(selectorSettings.map(value => value.buildAwsValue()))(
        _.selectorSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoSelector.ReadOnly =
    zio.aws.medialive.model.VideoSelector.wrap(buildAwsValue())
}
object VideoSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoSelector =
      zio.aws.medialive.model.VideoSelector(
        colorSpace.map(value => value),
        colorSpaceSettings.map(value => value.asEditable),
        colorSpaceUsage.map(value => value),
        selectorSettings.map(value => value.asEditable)
      )
    def colorSpace: Option[zio.aws.medialive.model.VideoSelectorColorSpace]
    def colorSpaceSettings: Option[
      zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly
    ]
    def colorSpaceUsage
        : Option[zio.aws.medialive.model.VideoSelectorColorSpaceUsage]
    def selectorSettings
        : Option[zio.aws.medialive.model.VideoSelectorSettings.ReadOnly]
    def getColorSpace
        : ZIO[Any, AwsError, zio.aws.medialive.model.VideoSelectorColorSpace] =
      AwsError.unwrapOptionField("colorSpace", colorSpace)
    def getColorSpaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("colorSpaceSettings", colorSpaceSettings)
    def getColorSpaceUsage: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoSelectorColorSpaceUsage
    ] = AwsError.unwrapOptionField("colorSpaceUsage", colorSpaceUsage)
    def getSelectorSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoSelectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("selectorSettings", selectorSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelector
  ) extends zio.aws.medialive.model.VideoSelector.ReadOnly {
    override val colorSpace
        : Option[zio.aws.medialive.model.VideoSelectorColorSpace] = scala
      .Option(impl.colorSpace())
      .map(value => zio.aws.medialive.model.VideoSelectorColorSpace.wrap(value))
    override val colorSpaceSettings: Option[
      zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly
    ] = scala
      .Option(impl.colorSpaceSettings())
      .map(value =>
        zio.aws.medialive.model.VideoSelectorColorSpaceSettings.wrap(value)
      )
    override val colorSpaceUsage
        : Option[zio.aws.medialive.model.VideoSelectorColorSpaceUsage] = scala
      .Option(impl.colorSpaceUsage())
      .map(value =>
        zio.aws.medialive.model.VideoSelectorColorSpaceUsage.wrap(value)
      )
    override val selectorSettings
        : Option[zio.aws.medialive.model.VideoSelectorSettings.ReadOnly] = scala
      .Option(impl.selectorSettings())
      .map(value => zio.aws.medialive.model.VideoSelectorSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelector
  ): zio.aws.medialive.model.VideoSelector.ReadOnly = new Wrapper(impl)
}
