package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait VideoSelectorColorSpace {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace
}
object VideoSelectorColorSpace {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace
  ): zio.aws.medialive.model.VideoSelectorColorSpace = value match {
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.FOLLOW =>
      val r = FOLLOW
      r
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.HDR10 =>
      val r = HDR10
      r
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.HLG_2020 =>
      val r = HLG_2020
      r
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.REC_601 =>
      val r = REC_601
      r
    case software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.REC_709 =>
      val r = REC_709
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLLOW extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.FOLLOW
  }
  case object HDR10 extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.HDR10
  }
  case object HLG_2020 extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.HLG_2020
  }
  case object REC_601 extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.REC_601
  }
  case object REC_709 extends zio.aws.medialive.model.VideoSelectorColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace =
      software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace.REC_709
  }
}
