package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoSelectorColorSpaceSettings(
    hdr10Settings: Option[zio.aws.medialive.model.Hdr10Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings = {
    import VideoSelectorColorSpaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings
      .builder()
      .optionallyWith(hdr10Settings.map(value => value.buildAwsValue()))(
        _.hdr10Settings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly =
    zio.aws.medialive.model.VideoSelectorColorSpaceSettings
      .wrap(buildAwsValue())
}
object VideoSelectorColorSpaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoSelectorColorSpaceSettings =
      zio.aws.medialive.model.VideoSelectorColorSpaceSettings(
        hdr10Settings.map(value => value.asEditable)
      )
    def hdr10Settings: Option[zio.aws.medialive.model.Hdr10Settings.ReadOnly]
    def getHdr10Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Hdr10Settings.ReadOnly] =
      AwsError.unwrapOptionField("hdr10Settings", hdr10Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings
  ) extends zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly {
    override val hdr10Settings
        : Option[zio.aws.medialive.model.Hdr10Settings.ReadOnly] = scala
      .Option(impl.hdr10Settings())
      .map(value => zio.aws.medialive.model.Hdr10Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings
  ): zio.aws.medialive.model.VideoSelectorColorSpaceSettings.ReadOnly =
    new Wrapper(impl)
}
