package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0Max8191
import scala.jdk.CollectionConverters._
final case class VideoSelectorPid(pid: Option[__integerMin0Max8191] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoSelectorPid = {
    import VideoSelectorPid.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoSelectorPid
      .builder()
      .optionallyWith(pid.map(value => value: Integer))(_.pid)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoSelectorPid.ReadOnly =
    zio.aws.medialive.model.VideoSelectorPid.wrap(buildAwsValue())
}
object VideoSelectorPid {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoSelectorPid
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoSelectorPid =
      zio.aws.medialive.model.VideoSelectorPid(pid.map(value => value))
    def pid: Option[__integerMin0Max8191]
    def getPid: ZIO[Any, AwsError, __integerMin0Max8191] =
      AwsError.unwrapOptionField("pid", pid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorPid
  ) extends zio.aws.medialive.model.VideoSelectorPid.ReadOnly {
    override val pid: Option[__integerMin0Max8191] =
      scala.Option(impl.pid()).map(value => value: __integerMin0Max8191)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorPid
  ): zio.aws.medialive.model.VideoSelectorPid.ReadOnly = new Wrapper(impl)
}
