package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0Max65536
import scala.jdk.CollectionConverters._
final case class VideoSelectorProgramId(
    programId: Option[__integerMin0Max65536] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId = {
    import VideoSelectorProgramId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId
      .builder()
      .optionallyWith(programId.map(value => value: Integer))(_.programId)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly =
    zio.aws.medialive.model.VideoSelectorProgramId.wrap(buildAwsValue())
}
object VideoSelectorProgramId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoSelectorProgramId =
      zio.aws.medialive.model
        .VideoSelectorProgramId(programId.map(value => value))
    def programId: Option[__integerMin0Max65536]
    def getProgramId: ZIO[Any, AwsError, __integerMin0Max65536] =
      AwsError.unwrapOptionField("programId", programId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId
  ) extends zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly {
    override val programId: Option[__integerMin0Max65536] =
      scala.Option(impl.programId()).map(value => value: __integerMin0Max65536)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId
  ): zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly = new Wrapper(impl)
}
