package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoSelectorSettings(
    videoSelectorPid: Option[zio.aws.medialive.model.VideoSelectorPid] = None,
    videoSelectorProgramId: Option[
      zio.aws.medialive.model.VideoSelectorProgramId
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VideoSelectorSettings = {
    import VideoSelectorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VideoSelectorSettings
      .builder()
      .optionallyWith(videoSelectorPid.map(value => value.buildAwsValue()))(
        _.videoSelectorPid
      )
      .optionallyWith(
        videoSelectorProgramId.map(value => value.buildAwsValue())
      )(_.videoSelectorProgramId)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VideoSelectorSettings.ReadOnly =
    zio.aws.medialive.model.VideoSelectorSettings.wrap(buildAwsValue())
}
object VideoSelectorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VideoSelectorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VideoSelectorSettings =
      zio.aws.medialive.model.VideoSelectorSettings(
        videoSelectorPid.map(value => value.asEditable),
        videoSelectorProgramId.map(value => value.asEditable)
      )
    def videoSelectorPid
        : Option[zio.aws.medialive.model.VideoSelectorPid.ReadOnly]
    def videoSelectorProgramId
        : Option[zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly]
    def getVideoSelectorPid: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoSelectorPid.ReadOnly
    ] = AwsError.unwrapOptionField("videoSelectorPid", videoSelectorPid)
    def getVideoSelectorProgramId: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly
    ] = AwsError.unwrapOptionField(
      "videoSelectorProgramId",
      videoSelectorProgramId
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorSettings
  ) extends zio.aws.medialive.model.VideoSelectorSettings.ReadOnly {
    override val videoSelectorPid
        : Option[zio.aws.medialive.model.VideoSelectorPid.ReadOnly] = scala
      .Option(impl.videoSelectorPid())
      .map(value => zio.aws.medialive.model.VideoSelectorPid.wrap(value))
    override val videoSelectorProgramId
        : Option[zio.aws.medialive.model.VideoSelectorProgramId.ReadOnly] =
      scala
        .Option(impl.videoSelectorProgramId())
        .map(value =>
          zio.aws.medialive.model.VideoSelectorProgramId.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VideoSelectorSettings
  ): zio.aws.medialive.model.VideoSelectorSettings.ReadOnly = new Wrapper(impl)
}
