package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class VpcOutputSettings(
    publicAddressAllocationIds: Option[Iterable[__string]] = None,
    securityGroupIds: Option[Iterable[__string]] = None,
    subnetIds: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VpcOutputSettings = {
    import VpcOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VpcOutputSettings
      .builder()
      .optionallyWith(
        publicAddressAllocationIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicAddressAllocationIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.VpcOutputSettings.ReadOnly =
    zio.aws.medialive.model.VpcOutputSettings.wrap(buildAwsValue())
}
object VpcOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VpcOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VpcOutputSettings =
      zio.aws.medialive.model.VpcOutputSettings(
        publicAddressAllocationIds.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds
      )
    def publicAddressAllocationIds: Option[List[__string]]
    def securityGroupIds: Option[List[__string]]
    def subnetIds: List[__string]
    def getPublicAddressAllocationIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "publicAddressAllocationIds",
        publicAddressAllocationIds
      )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VpcOutputSettings
  ) extends zio.aws.medialive.model.VpcOutputSettings.ReadOnly {
    override val publicAddressAllocationIds: Option[List[__string]] = scala
      .Option(impl.publicAddressAllocationIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val securityGroupIds: Option[List[__string]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VpcOutputSettings
  ): zio.aws.medialive.model.VpcOutputSettings.ReadOnly = new Wrapper(impl)
}
