package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class VpcOutputSettingsDescription(
    availabilityZones: Option[Iterable[__string]] = None,
    networkInterfaceIds: Option[Iterable[__string]] = None,
    securityGroupIds: Option[Iterable[__string]] = None,
    subnetIds: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription = {
    import VpcOutputSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly =
    zio.aws.medialive.model.VpcOutputSettingsDescription.wrap(buildAwsValue())
}
object VpcOutputSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.VpcOutputSettingsDescription =
      zio.aws.medialive.model.VpcOutputSettingsDescription(
        availabilityZones.map(value => value),
        networkInterfaceIds.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds.map(value => value)
      )
    def availabilityZones: Option[List[__string]]
    def networkInterfaceIds: Option[List[__string]]
    def securityGroupIds: Option[List[__string]]
    def subnetIds: Option[List[__string]]
    def getAvailabilityZones: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription
  ) extends zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly {
    override val availabilityZones: Option[List[__string]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val networkInterfaceIds: Option[List[__string]] = scala
      .Option(impl.networkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val securityGroupIds: Option[List[__string]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val subnetIds: Option[List[__string]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription
  ): zio.aws.medialive.model.VpcOutputSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
