package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait WavCodingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.WavCodingMode
}
object WavCodingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.WavCodingMode
  ): zio.aws.medialive.model.WavCodingMode = value match {
    case software.amazon.awssdk.services.medialive.model.WavCodingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_1_0 =>
      val r = CODING_MODE_1_0
      r
    case software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_2_0 =>
      val r = CODING_MODE_2_0
      r
    case software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_4_0 =>
      val r = CODING_MODE_4_0
      r
    case software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_8_0 =>
      val r = CODING_MODE_8_0
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.WavCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.WavCodingMode =
      software.amazon.awssdk.services.medialive.model.WavCodingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CODING_MODE_1_0 extends zio.aws.medialive.model.WavCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.WavCodingMode =
      software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_1_0
  }
  case object CODING_MODE_2_0 extends zio.aws.medialive.model.WavCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.WavCodingMode =
      software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_2_0
  }
  case object CODING_MODE_4_0 extends zio.aws.medialive.model.WavCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.WavCodingMode =
      software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_4_0
  }
  case object CODING_MODE_8_0 extends zio.aws.medialive.model.WavCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.WavCodingMode =
      software.amazon.awssdk.services.medialive.model.WavCodingMode.CODING_MODE_8_0
  }
}
