package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__double
import scala.jdk.CollectionConverters._
final case class WavSettings(
    bitDepth: Option[__double] = None,
    codingMode: Option[zio.aws.medialive.model.WavCodingMode] = None,
    sampleRate: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.WavSettings = {
    import WavSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.WavSettings
      .builder()
      .optionallyWith(bitDepth.map(value => value: java.lang.Double))(
        _.bitDepth
      )
      .optionallyWith(codingMode.map(value => value.unwrap))(_.codingMode)
      .optionallyWith(sampleRate.map(value => value: java.lang.Double))(
        _.sampleRate
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.WavSettings.ReadOnly =
    zio.aws.medialive.model.WavSettings.wrap(buildAwsValue())
}
object WavSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.WavSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.WavSettings =
      zio.aws.medialive.model.WavSettings(
        bitDepth.map(value => value),
        codingMode.map(value => value),
        sampleRate.map(value => value)
      )
    def bitDepth: Option[__double]
    def codingMode: Option[zio.aws.medialive.model.WavCodingMode]
    def sampleRate: Option[__double]
    def getBitDepth: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("bitDepth", bitDepth)
    def getCodingMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.WavCodingMode] =
      AwsError.unwrapOptionField("codingMode", codingMode)
    def getSampleRate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.WavSettings
  ) extends zio.aws.medialive.model.WavSettings.ReadOnly {
    override val bitDepth: Option[__double] =
      scala.Option(impl.bitDepth()).map(value => value: __double)
    override val codingMode: Option[zio.aws.medialive.model.WavCodingMode] =
      scala
        .Option(impl.codingMode())
        .map(value => zio.aws.medialive.model.WavCodingMode.wrap(value))
    override val sampleRate: Option[__double] =
      scala.Option(impl.sampleRate()).map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.WavSettings
  ): zio.aws.medialive.model.WavSettings.ReadOnly = new Wrapper(impl)
}
