package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WebvttDestinationSettings(
    styleControl: Option[
      zio.aws.medialive.model.WebvttDestinationStyleControl
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.WebvttDestinationSettings = {
    import WebvttDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.WebvttDestinationSettings
      .builder()
      .optionallyWith(styleControl.map(value => value.unwrap))(_.styleControl)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly =
    zio.aws.medialive.model.WebvttDestinationSettings.wrap(buildAwsValue())
}
object WebvttDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.WebvttDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.WebvttDestinationSettings =
      zio.aws.medialive.model
        .WebvttDestinationSettings(styleControl.map(value => value))
    def styleControl
        : Option[zio.aws.medialive.model.WebvttDestinationStyleControl]
    def getStyleControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.WebvttDestinationStyleControl
    ] = AwsError.unwrapOptionField("styleControl", styleControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.WebvttDestinationSettings
  ) extends zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly {
    override val styleControl
        : Option[zio.aws.medialive.model.WebvttDestinationStyleControl] = scala
      .Option(impl.styleControl())
      .map(value =>
        zio.aws.medialive.model.WebvttDestinationStyleControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.WebvttDestinationSettings
  ): zio.aws.medialive.model.WebvttDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
