package zio.aws.medialive
import java.time.Instant
import zio.aws.medialive.model.primitives.{__integer, __string}
import zio.aws.medialive.model.primitives.InputDeviceThumbnail.Type
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object InputDeviceThumbnail extends Subtype[Chunk[Byte]]
    type InputDeviceThumbnail =
      zio.aws.medialive.model.primitives.InputDeviceThumbnail.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.medialive.model.primitives.MaxResults.Type
    type __double = Double
    type __doubleMin0 = Double
    type __doubleMin0Max1 = Double
    type __doubleMin0Max100 = Double
    type __doubleMin1 = Double
    type __doubleMin1Max65535 = Double
    type __doubleMinNegative59Max0 = Double
    type __integer = Int
    type __integerMin0 = Int
    type __integerMin0Max10 = Int
    type __integerMin0Max100 = Int
    type __integerMin0Max1000 = Int
    type __integerMin0Max10000 = Int
    type __integerMin0Max1000000 = Int
    type __integerMin0Max100000000 = Int
    type __integerMin0Max128 = Int
    type __integerMin0Max15 = Int
    type __integerMin0Max255 = Int
    type __integerMin0Max30 = Int
    type __integerMin0Max32768 = Int
    type __integerMin0Max3600 = Int
    type __integerMin0Max500 = Int
    type __integerMin0Max600 = Int
    type __integerMin0Max65535 = Int
    type __integerMin0Max65536 = Int
    type __integerMin0Max7 = Int
    type __integerMin0Max8191 = Int
    type __integerMin1 = Int
    type __integerMin100 = Int
    type __integerMin1000 = Int
    type __integerMin1000000Max100000000 = Int
    type __integerMin100000Max100000000 = Int
    type __integerMin100000Max40000000 = Int
    type __integerMin100000Max80000000 = Int
    type __integerMin1000Max30000 = Int
    type __integerMin1Max10 = Int
    type __integerMin1Max1000000 = Int
    type __integerMin1Max16 = Int
    type __integerMin1Max20 = Int
    type __integerMin1Max3003 = Int
    type __integerMin1Max31 = Int
    type __integerMin1Max32 = Int
    type __integerMin1Max3600000 = Int
    type __integerMin1Max4 = Int
    type __integerMin1Max5 = Int
    type __integerMin1Max6 = Int
    type __integerMin1Max8 = Int
    type __integerMin25Max10000 = Int
    type __integerMin25Max2000 = Int
    type __integerMin3 = Int
    type __integerMin30 = Int
    type __integerMin32Max8191 = Int
    type __integerMin4Max20 = Int
    type __integerMin800Max3000 = Int
    type __integerMin96Max600 = Int
    type __integerMinNegative1000Max1000 = Int
    type __integerMinNegative5Max5 = Int
    type __integerMinNegative60Max6 = Int
    type __integerMinNegative60Max60 = Int
    type __long = Long
    type __longMin0Max1099511627775 = Long
    type __longMin0Max4294967295 = Long
    type __longMin0Max8589934591 = Long
    type __longMin0Max86400000 = Long
    type __string = String
    type __stringMax1000 = String
    type __stringMax256 = String
    type __stringMax32 = String
    type __stringMin1 = String
    type __stringMin1Max255 = String
    type __stringMin1Max256 = String
    type __stringMin1Max35 = String
    type __stringMin1Max7 = String
    type __stringMin2Max2 = String
    type __stringMin32Max32 = String
    type __stringMin34Max34 = String
    type __stringMin3Max3 = String
    type __stringMin6Max6 = String
    type __stringPattern010920300 = String
    type __timestamp = Instant
  }
  type Tags = Map[__string, __string]
  type __listOfAudioChannelMapping =
    List[zio.aws.medialive.model.AudioChannelMapping]
  type __listOfAudioDescription = List[zio.aws.medialive.model.AudioDescription]
  type __listOfAudioSelector = List[zio.aws.medialive.model.AudioSelector]
  type __listOfAudioTrack = List[zio.aws.medialive.model.AudioTrack]
  type __listOfBatchFailedResultModel =
    List[zio.aws.medialive.model.BatchFailedResultModel]
  type __listOfBatchSuccessfulResultModel =
    List[zio.aws.medialive.model.BatchSuccessfulResultModel]
  type __listOfCaptionDescription =
    List[zio.aws.medialive.model.CaptionDescription]
  type __listOfCaptionLanguageMapping =
    List[zio.aws.medialive.model.CaptionLanguageMapping]
  type __listOfCaptionSelector = List[zio.aws.medialive.model.CaptionSelector]
  type __listOfChannelEgressEndpoint =
    List[zio.aws.medialive.model.ChannelEgressEndpoint]
  type __listOfChannelSummary = List[zio.aws.medialive.model.ChannelSummary]
  type __listOfFailoverCondition =
    List[zio.aws.medialive.model.FailoverCondition]
  type __listOfHlsAdMarkers = List[zio.aws.medialive.model.HlsAdMarkers]
  type __listOfInput = List[zio.aws.medialive.model.Input]
  type __listOfInputAttachment = List[zio.aws.medialive.model.InputAttachment]
  type __listOfInputChannelLevel =
    List[zio.aws.medialive.model.InputChannelLevel]
  type __listOfInputDestination = List[zio.aws.medialive.model.InputDestination]
  type __listOfInputDestinationRequest =
    List[zio.aws.medialive.model.InputDestinationRequest]
  type __listOfInputDeviceRequest =
    List[zio.aws.medialive.model.InputDeviceRequest]
  type __listOfInputDeviceSettings =
    List[zio.aws.medialive.model.InputDeviceSettings]
  type __listOfInputDeviceSummary =
    List[zio.aws.medialive.model.InputDeviceSummary]
  type __listOfInputSecurityGroup =
    List[zio.aws.medialive.model.InputSecurityGroup]
  type __listOfInputSource = List[zio.aws.medialive.model.InputSource]
  type __listOfInputSourceRequest =
    List[zio.aws.medialive.model.InputSourceRequest]
  type __listOfInputWhitelistRule =
    List[zio.aws.medialive.model.InputWhitelistRule]
  type __listOfInputWhitelistRuleCidr =
    List[zio.aws.medialive.model.InputWhitelistRuleCidr]
  type __listOfMediaConnectFlow = List[zio.aws.medialive.model.MediaConnectFlow]
  type __listOfMediaConnectFlowRequest =
    List[zio.aws.medialive.model.MediaConnectFlowRequest]
  type __listOfMediaPackageOutputDestinationSettings =
    List[zio.aws.medialive.model.MediaPackageOutputDestinationSettings]
  type __listOfMultiplexOutputDestination =
    List[zio.aws.medialive.model.MultiplexOutputDestination]
  type __listOfMultiplexProgramPipelineDetail =
    List[zio.aws.medialive.model.MultiplexProgramPipelineDetail]
  type __listOfMultiplexProgramSummary =
    List[zio.aws.medialive.model.MultiplexProgramSummary]
  type __listOfMultiplexSummary = List[zio.aws.medialive.model.MultiplexSummary]
  type __listOfOffering = List[zio.aws.medialive.model.Offering]
  type __listOfOutput = List[zio.aws.medialive.model.Output]
  type __listOfOutputDestination =
    List[zio.aws.medialive.model.OutputDestination]
  type __listOfOutputDestinationSettings =
    List[zio.aws.medialive.model.OutputDestinationSettings]
  type __listOfOutputGroup = List[zio.aws.medialive.model.OutputGroup]
  type __listOfPipelineDetail = List[zio.aws.medialive.model.PipelineDetail]
  type __listOfPipelinePauseStateSettings =
    List[zio.aws.medialive.model.PipelinePauseStateSettings]
  type __listOfReservation = List[zio.aws.medialive.model.Reservation]
  type __listOfRtmpAdMarkers = List[zio.aws.medialive.model.RtmpAdMarkers]
  type __listOfScheduleAction = List[zio.aws.medialive.model.ScheduleAction]
  type __listOfScte35Descriptor = List[zio.aws.medialive.model.Scte35Descriptor]
  type __listOfTransferringInputDeviceSummary =
    List[zio.aws.medialive.model.TransferringInputDeviceSummary]
  type __listOfVideoDescription = List[zio.aws.medialive.model.VideoDescription]
  type __listOf__integer = List[__integer]
  type __listOf__string = List[__string]
}
