package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsRequest(
    egressAccessLogs: Option[zio.aws.mediapackage.model.EgressAccessLogs] =
      None,
    id: __string,
    ingressAccessLogs: Option[zio.aws.mediapackage.model.IngressAccessLogs] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest = {
    import ConfigureLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest
      .builder()
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .id(id: java.lang.String)
      .optionallyWith(ingressAccessLogs.map(value => value.buildAwsValue()))(
        _.ingressAccessLogs
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.ConfigureLogsRequest.ReadOnly =
    zio.aws.mediapackage.model.ConfigureLogsRequest.wrap(buildAwsValue())
}
object ConfigureLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ConfigureLogsRequest =
      zio.aws.mediapackage.model.ConfigureLogsRequest(
        egressAccessLogs.map(value => value.asEditable),
        id,
        ingressAccessLogs.map(value => value.asEditable)
      )
    def egressAccessLogs
        : Option[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly]
    def id: __string
    def ingressAccessLogs
        : Option[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly]
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIngressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("ingressAccessLogs", ingressAccessLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest
  ) extends zio.aws.mediapackage.model.ConfigureLogsRequest.ReadOnly {
    override val egressAccessLogs
        : Option[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly] = scala
      .Option(impl.egressAccessLogs())
      .map(value => zio.aws.mediapackage.model.EgressAccessLogs.wrap(value))
    override val id: __string = impl.id(): __string
    override val ingressAccessLogs
        : Option[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly] = scala
      .Option(impl.ingressAccessLogs())
      .map(value => zio.aws.mediapackage.model.IngressAccessLogs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ConfigureLogsRequest
  ): zio.aws.mediapackage.model.ConfigureLogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
