package zio.aws.mediastore
import zio.aws.mediastore.model.ListContainersResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.mediastore.{
  MediaStoreAsyncClientBuilder,
  MediaStoreAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.mediastore.model.{
  PutCorsPolicyRequest,
  DescribeContainerRequest,
  GetMetricPolicyRequest,
  DeleteContainerRequest,
  DeleteMetricPolicyRequest,
  StartAccessLoggingRequest,
  ListTagsForResourceRequest,
  PutContainerPolicyRequest,
  ListContainersRequest,
  StopAccessLoggingRequest,
  PutMetricPolicyRequest,
  GetContainerPolicyRequest,
  DeleteLifecyclePolicyRequest,
  GetCorsPolicyRequest,
  DeleteCorsPolicyRequest,
  UntagResourceRequest,
  CreateContainerRequest,
  DeleteContainerPolicyRequest,
  GetLifecyclePolicyRequest,
  PutLifecyclePolicyRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.mediastore.model.{
  DeleteMetricPolicyResponse,
  DeleteCorsPolicyResponse,
  DescribeContainerResponse,
  PutContainerPolicyResponse,
  GetMetricPolicyResponse,
  StopAccessLoggingResponse,
  StartAccessLoggingResponse,
  PutLifecyclePolicyResponse,
  DeleteLifecyclePolicyResponse,
  PutCorsPolicyResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  Container,
  GetLifecyclePolicyResponse,
  DeleteContainerPolicyResponse,
  GetCorsPolicyResponse,
  PutMetricPolicyResponse,
  DeleteContainerResponse,
  TagResourceResponse,
  GetContainerPolicyResponse,
  ListContainersResponse,
  CreateContainerResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MediaStore extends AspectSupport[MediaStore] {
  val api: MediaStoreAsyncClient
  def deleteMetricPolicy(
      request: DeleteMetricPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.DeleteMetricPolicyResponse.ReadOnly]
  def deleteContainer(
      request: DeleteContainerRequest
  ): IO[AwsError, zio.aws.mediastore.model.DeleteContainerResponse.ReadOnly]
  def deleteContainerPolicy(request: DeleteContainerPolicyRequest): IO[
    AwsError,
    zio.aws.mediastore.model.DeleteContainerPolicyResponse.ReadOnly
  ]
  def getCorsPolicy(
      request: GetCorsPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly]
  def deleteCorsPolicy(
      request: DeleteCorsPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.DeleteCorsPolicyResponse.ReadOnly]
  def putLifecyclePolicy(
      request: PutLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.PutLifecyclePolicyResponse.ReadOnly]
  def putMetricPolicy(
      request: PutMetricPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.PutMetricPolicyResponse.ReadOnly]
  def startAccessLogging(
      request: StartAccessLoggingRequest
  ): IO[AwsError, zio.aws.mediastore.model.StartAccessLoggingResponse.ReadOnly]
  def putCorsPolicy(
      request: PutCorsPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.PutCorsPolicyResponse.ReadOnly]
  def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): IO[
    AwsError,
    zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.mediastore.model.UntagResourceResponse.ReadOnly]
  def getMetricPolicy(
      request: GetMetricPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.GetMetricPolicyResponse.ReadOnly]
  def putContainerPolicy(
      request: PutContainerPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.PutContainerPolicyResponse.ReadOnly]
  def listContainers(
      request: ListContainersRequest
  ): ZStream[Any, AwsError, zio.aws.mediastore.model.Container.ReadOnly]
  def listContainersPaginated(
      request: ListContainersRequest
  ): IO[AwsError, ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.mediastore.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.mediastore.model.TagResourceResponse.ReadOnly]
  def stopAccessLogging(
      request: StopAccessLoggingRequest
  ): IO[AwsError, zio.aws.mediastore.model.StopAccessLoggingResponse.ReadOnly]
  def getContainerPolicy(
      request: GetContainerPolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly]
  def describeContainer(
      request: DescribeContainerRequest
  ): IO[AwsError, zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly]
  def createContainer(
      request: CreateContainerRequest
  ): IO[AwsError, zio.aws.mediastore.model.CreateContainerResponse.ReadOnly]
  def getLifecyclePolicy(
      request: GetLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.mediastore.model.GetLifecyclePolicyResponse.ReadOnly]
}
object MediaStore {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaStore] = customized(
    identity
  )
  def customized(
      customization: MediaStoreAsyncClientBuilder => MediaStoreAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaStore] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaStoreAsyncClientBuilder => MediaStoreAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaStore] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaStoreAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaStoreAsyncClient, MediaStoreAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[MediaStoreAsyncClient, MediaStoreAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new MediaStoreImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MediaStoreImpl[R](
      override val api: MediaStoreAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaStore
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaStore"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaStoreImpl[R1] = new MediaStoreImpl(api, newAspect, r)
    def deleteMetricPolicy(request: DeleteMetricPolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.DeleteMetricPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest,
      DeleteMetricPolicyResponse
    ]("deleteMetricPolicy", api.deleteMetricPolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.DeleteMetricPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteContainer(
        request: DeleteContainerRequest
    ): IO[AwsError, zio.aws.mediastore.model.DeleteContainerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest,
        DeleteContainerResponse
      ]("deleteContainer", api.deleteContainer)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.DeleteContainerResponse.wrap)
        .provideEnvironment(r)
    def deleteContainerPolicy(request: DeleteContainerPolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.DeleteContainerPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest,
      DeleteContainerPolicyResponse
    ]("deleteContainerPolicy", api.deleteContainerPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.mediastore.model.DeleteContainerPolicyResponse.wrap)
      .provideEnvironment(r)
    def getCorsPolicy(
        request: GetCorsPolicyRequest
    ): IO[AwsError, zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest,
        GetCorsPolicyResponse
      ]("getCorsPolicy", api.getCorsPolicy)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.GetCorsPolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteCorsPolicy(request: DeleteCorsPolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.DeleteCorsPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest,
      DeleteCorsPolicyResponse
    ]("deleteCorsPolicy", api.deleteCorsPolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.DeleteCorsPolicyResponse.wrap)
      .provideEnvironment(r)
    def putLifecyclePolicy(request: PutLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.PutLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest,
      PutLifecyclePolicyResponse
    ]("putLifecyclePolicy", api.putLifecyclePolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.PutLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def putMetricPolicy(
        request: PutMetricPolicyRequest
    ): IO[AwsError, zio.aws.mediastore.model.PutMetricPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest,
        PutMetricPolicyResponse
      ]("putMetricPolicy", api.putMetricPolicy)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.PutMetricPolicyResponse.wrap)
        .provideEnvironment(r)
    def startAccessLogging(request: StartAccessLoggingRequest): IO[
      AwsError,
      zio.aws.mediastore.model.StartAccessLoggingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest,
      StartAccessLoggingResponse
    ]("startAccessLogging", api.startAccessLogging)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.StartAccessLoggingResponse.wrap)
      .provideEnvironment(r)
    def putCorsPolicy(
        request: PutCorsPolicyRequest
    ): IO[AwsError, zio.aws.mediastore.model.PutCorsPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest,
        PutCorsPolicyResponse
      ]("putCorsPolicy", api.putCorsPolicy)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.PutCorsPolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest,
      DeleteLifecyclePolicyResponse
    ]("deleteLifecyclePolicy", api.deleteLifecyclePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.mediastore.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getMetricPolicy(
        request: GetMetricPolicyRequest
    ): IO[AwsError, zio.aws.mediastore.model.GetMetricPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest,
        GetMetricPolicyResponse
      ]("getMetricPolicy", api.getMetricPolicy)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.GetMetricPolicyResponse.wrap)
        .provideEnvironment(r)
    def putContainerPolicy(request: PutContainerPolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.PutContainerPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest,
      PutContainerPolicyResponse
    ]("putContainerPolicy", api.putContainerPolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.PutContainerPolicyResponse.wrap)
      .provideEnvironment(r)
    def listContainers(
        request: ListContainersRequest
    ): ZStream[Any, AwsError, zio.aws.mediastore.model.Container.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediastore.model.ListContainersRequest,
        ListContainersResponse,
        Container
      ](
        "listContainers",
        api.listContainers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.containers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediastore.model.Container.wrap(item))
        .provideEnvironment(r)
    def listContainersPaginated(
        request: ListContainersRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.ListContainersRequest,
      ListContainersResponse
    ]("listContainers", api.listContainers)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.ListContainersResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.mediastore.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.mediastore.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def stopAccessLogging(request: StopAccessLoggingRequest): IO[
      AwsError,
      zio.aws.mediastore.model.StopAccessLoggingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest,
      StopAccessLoggingResponse
    ]("stopAccessLogging", api.stopAccessLogging)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.StopAccessLoggingResponse.wrap)
      .provideEnvironment(r)
    def getContainerPolicy(request: GetContainerPolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.GetContainerPolicyRequest,
      GetContainerPolicyResponse
    ]("getContainerPolicy", api.getContainerPolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.GetContainerPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeContainer(request: DescribeContainerRequest): IO[
      AwsError,
      zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest,
      DescribeContainerResponse
    ]("describeContainer", api.describeContainer)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.DescribeContainerResponse.wrap)
      .provideEnvironment(r)
    def createContainer(
        request: CreateContainerRequest
    ): IO[AwsError, zio.aws.mediastore.model.CreateContainerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastore.model.CreateContainerRequest,
        CreateContainerResponse
      ]("createContainer", api.createContainer)(request.buildAwsValue())
        .map(zio.aws.mediastore.model.CreateContainerResponse.wrap)
        .provideEnvironment(r)
    def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
      AwsError,
      zio.aws.mediastore.model.GetLifecyclePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest,
      GetLifecyclePolicyResponse
    ]("getLifecyclePolicy", api.getLifecyclePolicy)(request.buildAwsValue())
      .map(zio.aws.mediastore.model.GetLifecyclePolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteMetricPolicy(request: DeleteMetricPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DeleteMetricPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMetricPolicy(request))
  def deleteContainer(request: DeleteContainerRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DeleteContainerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainer(request))
  def deleteContainerPolicy(request: DeleteContainerPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DeleteContainerPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainerPolicy(request))
  def getCorsPolicy(request: GetCorsPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCorsPolicy(request))
  def deleteCorsPolicy(request: DeleteCorsPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DeleteCorsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCorsPolicy(request))
  def putLifecyclePolicy(request: PutLifecyclePolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.PutLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLifecyclePolicy(request))
  def putMetricPolicy(request: PutMetricPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.PutMetricPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMetricPolicy(request))
  def startAccessLogging(request: StartAccessLoggingRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.StartAccessLoggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAccessLogging(request))
  def putCorsPolicy(request: PutCorsPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.PutCorsPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putCorsPolicy(request))
  def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLifecyclePolicy(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getMetricPolicy(request: GetMetricPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.GetMetricPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricPolicy(request))
  def putContainerPolicy(request: PutContainerPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.PutContainerPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putContainerPolicy(request))
  def listContainers(request: ListContainersRequest): ZStream[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.Container.ReadOnly
  ] = ZStream.serviceWithStream(_.listContainers(request))
  def listContainersPaginated(
      request: ListContainersRequest
  ): ZIO[zio.aws.mediastore.MediaStore, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listContainersPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def stopAccessLogging(request: StopAccessLoggingRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.StopAccessLoggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopAccessLogging(request))
  def getContainerPolicy(request: GetContainerPolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerPolicy(request))
  def describeContainer(request: DescribeContainerRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContainer(request))
  def createContainer(request: CreateContainerRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.CreateContainerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainer(request))
  def getLifecyclePolicy(request: GetLifecyclePolicyRequest): ZIO[
    zio.aws.mediastore.MediaStore,
    AwsError,
    zio.aws.mediastore.model.GetLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLifecyclePolicy(request))
}
