package zio.aws.mediastore
import zio.aws.mediastore.model.ListContainersResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.mediastore.MediaStoreAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.mediastore.model.{
  PutCorsPolicyRequest,
  DescribeContainerRequest,
  GetMetricPolicyRequest,
  DeleteContainerRequest,
  DeleteMetricPolicyRequest,
  StartAccessLoggingRequest,
  ListTagsForResourceRequest,
  PutContainerPolicyRequest,
  ListContainersRequest,
  StopAccessLoggingRequest,
  PutMetricPolicyRequest,
  GetContainerPolicyRequest,
  DeleteLifecyclePolicyRequest,
  GetCorsPolicyRequest,
  DeleteCorsPolicyRequest,
  UntagResourceRequest,
  CreateContainerRequest,
  DeleteContainerPolicyRequest,
  GetLifecyclePolicyRequest,
  PutLifecyclePolicyRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object MediaStoreMock extends Mock[MediaStore] {
  object DeleteMetricPolicy
      extends Effect[
        DeleteMetricPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.DeleteMetricPolicyResponse.ReadOnly
      ]
  object DeleteContainer
      extends Effect[
        DeleteContainerRequest,
        AwsError,
        zio.aws.mediastore.model.DeleteContainerResponse.ReadOnly
      ]
  object DeleteContainerPolicy
      extends Effect[
        DeleteContainerPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.DeleteContainerPolicyResponse.ReadOnly
      ]
  object GetCorsPolicy
      extends Effect[
        GetCorsPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly
      ]
  object DeleteCorsPolicy
      extends Effect[
        DeleteCorsPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.DeleteCorsPolicyResponse.ReadOnly
      ]
  object PutLifecyclePolicy
      extends Effect[
        PutLifecyclePolicyRequest,
        AwsError,
        zio.aws.mediastore.model.PutLifecyclePolicyResponse.ReadOnly
      ]
  object PutMetricPolicy
      extends Effect[
        PutMetricPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.PutMetricPolicyResponse.ReadOnly
      ]
  object StartAccessLogging
      extends Effect[
        StartAccessLoggingRequest,
        AwsError,
        zio.aws.mediastore.model.StartAccessLoggingResponse.ReadOnly
      ]
  object PutCorsPolicy
      extends Effect[
        PutCorsPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.PutCorsPolicyResponse.ReadOnly
      ]
  object DeleteLifecyclePolicy
      extends Effect[
        DeleteLifecyclePolicyRequest,
        AwsError,
        zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.mediastore.model.UntagResourceResponse.ReadOnly
      ]
  object GetMetricPolicy
      extends Effect[
        GetMetricPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.GetMetricPolicyResponse.ReadOnly
      ]
  object PutContainerPolicy
      extends Effect[
        PutContainerPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.PutContainerPolicyResponse.ReadOnly
      ]
  object ListContainers
      extends Stream[
        ListContainersRequest,
        AwsError,
        zio.aws.mediastore.model.Container.ReadOnly
      ]
  object ListContainersPaginated
      extends Effect[ListContainersRequest, AwsError, ReadOnly]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mediastore.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.mediastore.model.TagResourceResponse.ReadOnly
      ]
  object StopAccessLogging
      extends Effect[
        StopAccessLoggingRequest,
        AwsError,
        zio.aws.mediastore.model.StopAccessLoggingResponse.ReadOnly
      ]
  object GetContainerPolicy
      extends Effect[
        GetContainerPolicyRequest,
        AwsError,
        zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly
      ]
  object DescribeContainer
      extends Effect[
        DescribeContainerRequest,
        AwsError,
        zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly
      ]
  object CreateContainer
      extends Effect[
        CreateContainerRequest,
        AwsError,
        zio.aws.mediastore.model.CreateContainerResponse.ReadOnly
      ]
  object GetLifecyclePolicy
      extends Effect[
        GetLifecyclePolicyRequest,
        AwsError,
        zio.aws.mediastore.model.GetLifecyclePolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaStore] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MediaStore] { rts =>
        zio.ZIO.succeed {
          new MediaStore {
            val api: MediaStoreAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MediaStore = this
            def deleteMetricPolicy(request: DeleteMetricPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.DeleteMetricPolicyResponse.ReadOnly
            ] = proxy(DeleteMetricPolicy, request)
            def deleteContainer(request: DeleteContainerRequest): IO[
              AwsError,
              zio.aws.mediastore.model.DeleteContainerResponse.ReadOnly
            ] = proxy(DeleteContainer, request)
            def deleteContainerPolicy(
                request: DeleteContainerPolicyRequest
            ): IO[
              AwsError,
              zio.aws.mediastore.model.DeleteContainerPolicyResponse.ReadOnly
            ] = proxy(DeleteContainerPolicy, request)
            def getCorsPolicy(request: GetCorsPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly
            ] = proxy(GetCorsPolicy, request)
            def deleteCorsPolicy(request: DeleteCorsPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.DeleteCorsPolicyResponse.ReadOnly
            ] = proxy(DeleteCorsPolicy, request)
            def putLifecyclePolicy(request: PutLifecyclePolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.PutLifecyclePolicyResponse.ReadOnly
            ] = proxy(PutLifecyclePolicy, request)
            def putMetricPolicy(request: PutMetricPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.PutMetricPolicyResponse.ReadOnly
            ] = proxy(PutMetricPolicy, request)
            def startAccessLogging(request: StartAccessLoggingRequest): IO[
              AwsError,
              zio.aws.mediastore.model.StartAccessLoggingResponse.ReadOnly
            ] = proxy(StartAccessLogging, request)
            def putCorsPolicy(request: PutCorsPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.PutCorsPolicyResponse.ReadOnly
            ] = proxy(PutCorsPolicy, request)
            def deleteLifecyclePolicy(
                request: DeleteLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.mediastore.model.DeleteLifecyclePolicyResponse.ReadOnly
            ] = proxy(DeleteLifecyclePolicy, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.mediastore.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getMetricPolicy(request: GetMetricPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.GetMetricPolicyResponse.ReadOnly
            ] = proxy(GetMetricPolicy, request)
            def putContainerPolicy(request: PutContainerPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.PutContainerPolicyResponse.ReadOnly
            ] = proxy(PutContainerPolicy, request)
            def listContainers(request: ListContainersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mediastore.model.Container.ReadOnly
            ] = rts.unsafeRun(proxy(ListContainers, request))
            def listContainersPaginated(
                request: ListContainersRequest
            ): IO[AwsError, ReadOnly] = proxy(ListContainersPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.mediastore.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.mediastore.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def stopAccessLogging(request: StopAccessLoggingRequest): IO[
              AwsError,
              zio.aws.mediastore.model.StopAccessLoggingResponse.ReadOnly
            ] = proxy(StopAccessLogging, request)
            def getContainerPolicy(request: GetContainerPolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly
            ] = proxy(GetContainerPolicy, request)
            def describeContainer(request: DescribeContainerRequest): IO[
              AwsError,
              zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly
            ] = proxy(DescribeContainer, request)
            def createContainer(request: CreateContainerRequest): IO[
              AwsError,
              zio.aws.mediastore.model.CreateContainerResponse.ReadOnly
            ] = proxy(CreateContainer, request)
            def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
              AwsError,
              zio.aws.mediastore.model.GetLifecyclePolicyResponse.ReadOnly
            ] = proxy(GetLifecyclePolicy, request)
          }
        }
      }
    }
  }
}
