package zio.aws.mediastore.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mediastore.model.primitives.{
  ContainerARN,
  ContainerAccessLoggingEnabled,
  Endpoint,
  TimeStamp,
  ContainerName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Container(
    endpoint: Optional[Endpoint] = Optional.Absent,
    creationTime: Optional[TimeStamp] = Optional.Absent,
    arn: Optional[ContainerARN] = Optional.Absent,
    name: Optional[ContainerName] = Optional.Absent,
    status: Optional[zio.aws.mediastore.model.ContainerStatus] =
      Optional.Absent,
    accessLoggingEnabled: Optional[ContainerAccessLoggingEnabled] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.Container
      .builder()
      .optionallyWith(
        endpoint.map(value => Endpoint.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        creationTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        arn.map(value => ContainerARN.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ContainerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        accessLoggingEnabled.map(value =>
          ContainerAccessLoggingEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.accessLoggingEnabled)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.Container.ReadOnly =
    zio.aws.mediastore.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.Container =
      zio.aws.mediastore.model.Container(
        endpoint.map(value => value),
        creationTime.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        accessLoggingEnabled.map(value => value)
      )
    def endpoint: Optional[Endpoint]
    def creationTime: Optional[TimeStamp]
    def arn: Optional[ContainerARN]
    def name: Optional[ContainerName]
    def status: Optional[zio.aws.mediastore.model.ContainerStatus]
    def accessLoggingEnabled: Optional[ContainerAccessLoggingEnabled]
    def getEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getCreationTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getArn: ZIO[Any, AwsError, ContainerARN] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ContainerName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.mediastore.model.ContainerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAccessLoggingEnabled
        : ZIO[Any, AwsError, ContainerAccessLoggingEnabled] =
      AwsError.unwrapOptionField("accessLoggingEnabled", accessLoggingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.Container
  ) extends zio.aws.mediastore.model.Container.ReadOnly {
    override val endpoint: Optional[Endpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => zio.aws.mediastore.model.primitives.Endpoint(value))
    override val creationTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.mediastore.model.primitives.TimeStamp(value))
    override val arn: Optional[ContainerARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.mediastore.model.primitives.ContainerARN(value))
    override val name: Optional[ContainerName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mediastore.model.primitives.ContainerName(value))
    override val status: Optional[zio.aws.mediastore.model.ContainerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mediastore.model.ContainerStatus.wrap(value))
    override val accessLoggingEnabled: Optional[ContainerAccessLoggingEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLoggingEnabled())
        .map(value =>
          zio.aws.mediastore.model.primitives
            .ContainerAccessLoggingEnabled(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.Container
  ): zio.aws.mediastore.model.Container.ReadOnly = new Wrapper(impl)
}
